/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.audit.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.audit.mapper.SfaAuditTpmMapper;
import com.biz.crm.audit.model.SfaAuditTpmEntity;
import com.biz.crm.audit.service.ISfaAuditInspectorsService;
import com.biz.crm.audit.service.ISfaAuditTpmService;
import com.biz.crm.audit.trans.SfaAuditAndActToActDetail;
import com.biz.crm.audit.utils.SfaAuditAreaUtils;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.sfa.SfaCommonEnum;
import com.biz.crm.mdm.terminal.MdmTerminalFeign;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.nebular.sfa.audit.req.SfaAuditTpmReqVo;
import com.biz.crm.nebular.sfa.audit.req.SfaTPMTerminalReqVo;
import com.biz.crm.nebular.sfa.audit.resp.SfaAuditInspectorsRespVo;
import com.biz.crm.nebular.sfa.audit.resp.SfaAuditTpmActInfoRespVo;
import com.biz.crm.nebular.sfa.audit.resp.SfaAuditTpmRespVo;
import com.biz.crm.nebular.sfa.tpmact.req.SfaTpmActReqVo;
import com.biz.crm.nebular.sfa.tpmact.resp.SfaTpmActRespVo;
import com.biz.crm.nebular.tpm.act.req.TpmActDetailReqVo;
import com.biz.crm.nebular.tpm.act.resp.TpmActDetailRespVo;
import com.biz.crm.tpm.act.TpmActDetailFeign;
import com.biz.crm.tpmact.service.ISfaTpmActDetailService;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.Result;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"SfaAuditTpmServiceExpandImpl"})
public class SfaAuditTpmServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SfaAuditTpmMapper, SfaAuditTpmEntity>
implements ISfaAuditTpmService {
    private static final Logger log = LoggerFactory.getLogger(SfaAuditTpmServiceImpl.class);
    @Resource
    private SfaAuditTpmMapper sfaAuditTpmMapper;
    @Resource
    private ISfaAuditInspectorsService inspectorsService;
    @Resource
    private MdmTerminalFeign mdmTerminalFeign;
    @Resource
    private ISfaTpmActDetailService iSfaTpmActDetailService;
    @Resource
    private TpmActDetailFeign tpmActDetailFeign;

    @Override
    public PageResult<SfaAuditTpmRespVo> findList(SfaAuditTpmReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<SfaAuditTpmRespVo> list = this.sfaAuditTpmMapper.findList((Page<SfaAuditTpmRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public SfaAuditTpmRespVo query(SfaAuditTpmReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        SfaAuditTpmEntity sfaAuditTpmEntity = (SfaAuditTpmEntity)((Object)this.sfaAuditTpmMapper.selectById((Serializable)((Object)reqVo.getId())));
        SfaAuditTpmRespVo respVo = (SfaAuditTpmRespVo)CrmBeanUtil.copy((Object)((Object)sfaAuditTpmEntity), SfaAuditTpmRespVo.class);
        return respVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(SfaAuditTpmReqVo reqVo) {
        SfaAuditTpmEntity entity = (SfaAuditTpmEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaAuditTpmEntity.class));
        Map<String, String> auditArea = new SfaAuditAreaUtils().getAuditArea(reqVo.getAuditAreaCode());
        entity.setAuditAreaCode(auditArea.get("code"));
        entity.setAuditArea(auditArea.get("name"));
        this.save((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(SfaAuditTpmReqVo reqVo) {
        SfaAuditTpmEntity entity = (SfaAuditTpmEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        this.updateById((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(SfaAuditTpmReqVo reqVo) {
        List sfaAuditTpmEntities = this.sfaAuditTpmMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaAuditTpmEntities)) {
            sfaAuditTpmEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
        }
        this.updateBatchById(sfaAuditTpmEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(SfaAuditTpmReqVo reqVo) {
        List sfaAuditTpmEntities = this.sfaAuditTpmMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaAuditTpmEntities)) {
            sfaAuditTpmEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(sfaAuditTpmEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(SfaAuditTpmReqVo reqVo) {
        List sfaAuditTpmEntities = this.sfaAuditTpmMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaAuditTpmEntities)) {
            sfaAuditTpmEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(sfaAuditTpmEntities);
    }

    @Override
    public List<MdmTerminalVo> queryTpmInfo(SfaTPMTerminalReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getAuditAccount(), (String)"\u767b\u5f55\u8d26\u53f7\u4e0d\u80fd\u4e0d\u7a7a");
        SfaAuditInspectorsRespVo respVo = this.inspectorsService.queryInfoByAccount(reqVo.getAuditAccount());
        List auditAreaCode = respVo.getAuditAreaCode();
        reqVo.setAuditAreaCode(auditAreaCode);
        Result listResult = this.mdmTerminalFeign.queryTerminalByOrgCodeList(reqVo);
        List result = (List)listResult.getResult();
        return result;
    }

    @Override
    public List<SfaAuditTpmRespVo> queryTpmByTerminalCode(SfaAuditTpmReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getAuditTerminalCode(), (String)"\u7ec8\u7aef\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        List<SfaAuditTpmRespVo> sfaAuditTpmRespVos = this.sfaAuditTpmMapper.queryTpmByTerminal(reqVo);
        return sfaAuditTpmRespVos;
    }

    @Override
    public List<SfaTpmActRespVo> queryTpmAuditAct(SfaTpmActReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getTerminalCode(), (String)"\u7ec8\u7aef\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        List<SfaAuditTpmRespVo> sfaAuditTpmRespVos = this.sfaAuditTpmMapper.queryActCodeByTerminal(reqVo.getTerminalCode());
        List auditActList = sfaAuditTpmRespVos.stream().map(SfaAuditTpmRespVo::getActCode).collect(Collectors.toList());
        LinkedList tpmAuditList = Lists.newLinkedList();
        List<SfaTpmActRespVo> tpmAct = this.findTpmAct(reqVo);
        tpmAct.stream().forEach(o -> {
            if (auditActList.contains(o.getActCode())) {
                tpmAuditList.add(o);
            }
        });
        return tpmAuditList;
    }

    @Override
    public List<SfaTpmActRespVo> queryTpmToAuditAct(SfaTpmActReqVo reqVo) {
        List<SfaAuditTpmRespVo> AuditTpmRespVos = this.sfaAuditTpmMapper.queryActCodeByTerminal(reqVo.getTerminalCode());
        List auditActList = AuditTpmRespVos.stream().map(SfaAuditTpmRespVo::getActCode).collect(Collectors.toList());
        LinkedList tpmToAuditList = Lists.newLinkedList();
        List<SfaTpmActRespVo> tpmAct = this.findTpmAct(reqVo);
        tpmAct.stream().forEach(o -> {
            if (!auditActList.contains(o.getActCode())) {
                tpmToAuditList.add(o);
            }
        });
        return tpmToAuditList;
    }

    @Override
    public List<SfaAuditTpmActInfoRespVo> queryTpmActDetail(SfaAuditTpmReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getAuditTerminalCode(), (String)"\u7ec8\u7aef\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getActCode(), (String)"\u6d3b\u52a8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        TpmActDetailReqVo tpmReq = new TpmActDetailReqVo();
        tpmReq.setActCode(reqVo.getActCode());
        Result list = this.tpmActDetailFeign.list(tpmReq);
        List data = ((PageResult)list.getResult()).getData();
        List collect = data.stream().filter(o -> reqVo.getAuditTerminalCode().equals(o.getTerminalCode())).collect(Collectors.toList());
        SfaAuditTpmReqVo auditReqVo = new SfaAuditTpmReqVo();
        auditReqVo.setAuditTerminalCode(reqVo.getAuditTerminalCode());
        List<SfaAuditTpmRespVo> sfaAuditTpmRespVos = this.queryTpmByTerminalCode(auditReqVo);
        Map<String, SfaAuditTpmRespVo> auditMap = sfaAuditTpmRespVos.stream().collect(Collectors.toMap(SfaAuditTpmRespVo::getAuditTerminalCode, vo -> vo, (v1, v2) -> v1));
        ArrayList actInfo = Lists.newArrayList();
        collect.stream().forEach(o -> actInfo.add(new SfaAuditAndActToActDetail().apply((TpmActDetailRespVo)o)));
        actInfo.stream().forEach(o -> {
            if (auditMap.containsKey(o.getTerminalCode())) {
                o.setAuditAddress(((SfaAuditTpmRespVo)auditMap.get(o.getTerminalCode())).getAuditAddress());
                o.setAuditDate(((SfaAuditTpmRespVo)auditMap.get(o.getTerminalCode())).getAuditDate());
            }
        });
        return actInfo;
    }

    @Override
    public List<SfaAuditTpmActInfoRespVo> queryTpmActAuditDetail(SfaAuditTpmReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getAuditTerminalCode(), (String)"\u7ec8\u7aef\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getActCode(), (String)"\u6d3b\u52a8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        reqVo.setAuditCode(CodeUtil.createCode());
        TpmActDetailReqVo tpmReq = new TpmActDetailReqVo();
        tpmReq.setActCode(reqVo.getActCode());
        Result list = this.tpmActDetailFeign.list(tpmReq);
        List data = ((PageResult)list.getResult()).getData();
        List collect = data.stream().filter(o -> reqVo.getAuditTerminalCode().equals(o.getTerminalCode())).collect(Collectors.toList());
        SfaAuditTpmReqVo auditReqVo = new SfaAuditTpmReqVo();
        auditReqVo.setAuditTerminalCode(reqVo.getAuditTerminalCode());
        auditReqVo.setActCode(reqVo.getActCode());
        List<SfaAuditTpmRespVo> sfaAuditTpmRespVos = this.sfaAuditTpmMapper.queryAuditByCodes(auditReqVo);
        Map<String, SfaAuditTpmRespVo> auditMap = sfaAuditTpmRespVos.stream().collect(Collectors.toMap(SfaAuditTpmRespVo::getAuditTerminalCode, vo -> vo, (v1, v2) -> v1));
        ArrayList actInfos = Lists.newArrayList();
        collect.stream().forEach(o -> actInfos.add(new SfaAuditAndActToActDetail().apply((TpmActDetailRespVo)o)));
        actInfos.stream().forEach(o -> {
            if (auditMap.containsKey(o.getTerminalCode())) {
                o.setAuditAddress(((SfaAuditTpmRespVo)auditMap.get(o.getTerminalCode())).getAuditAddress());
                o.setAuditDate(((SfaAuditTpmRespVo)auditMap.get(o.getTerminalCode())).getAuditDate());
                o.setAuditResult(((SfaAuditTpmRespVo)auditMap.get(o.getTerminalCode())).getAuditResult());
                o.setAuditResultDesc(((SfaAuditTpmRespVo)auditMap.get(o.getTerminalCode())).getAuditResultDesc());
                o.setAuditPicture(((SfaAuditTpmRespVo)auditMap.get(o.getTerminalCode())).getAuditPicture());
            }
        });
        return actInfos;
    }

    private List<SfaTpmActRespVo> findTpmAct(SfaTpmActReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getTerminalCode(), (String)"\u7ec8\u7aef\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList tpmList = Lists.newArrayList();
        reqVo.setSfaTpmActStatus(SfaCommonEnum.sfaTpmActStatus.onGoing.getValue());
        PageResult<SfaTpmActRespVo> tpmActListOnGoing = this.iSfaTpmActDetailService.getTpmActList(reqVo);
        tpmList.addAll(tpmActListOnGoing.getData());
        reqVo.setSfaTpmActStatus(SfaCommonEnum.sfaTpmActStatus.alreadySuccess.getValue());
        PageResult<SfaTpmActRespVo> tpmActListAlready = this.iSfaTpmActDetailService.getTpmActList(reqVo);
        tpmList.addAll(tpmActListAlready.getData());
        return tpmList;
    }
}

