/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.audit.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.audit.mapper.SfaAuditTransregionalMapper;
import com.biz.crm.audit.model.SfaAuditTransregionalEntity;
import com.biz.crm.audit.service.ISfaAuditTransregionalService;
import com.biz.crm.audit.utils.AuditAccountUtils;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.sfa.audit.req.SfaAuditTransregionalReqVo;
import com.biz.crm.nebular.sfa.audit.resp.SfaAuditTransregionalRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"SfaAuditTransregionalServiceExpandImpl"})
public class SfaAuditTransregionalServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SfaAuditTransregionalMapper, SfaAuditTransregionalEntity>
implements ISfaAuditTransregionalService {
    private static final Logger log = LoggerFactory.getLogger(SfaAuditTransregionalServiceImpl.class);
    @Resource
    private SfaAuditTransregionalMapper sfaAuditTransregionalMapper;

    @Override
    public PageResult<SfaAuditTransregionalRespVo> findList(SfaAuditTransregionalReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<SfaAuditTransregionalRespVo> list = this.sfaAuditTransregionalMapper.findList((Page<SfaAuditTransregionalRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public SfaAuditTransregionalRespVo query(SfaAuditTransregionalReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        SfaAuditTransregionalEntity sfaAuditTransregionalEntity = (SfaAuditTransregionalEntity)((Object)this.sfaAuditTransregionalMapper.selectById((Serializable)((Object)reqVo.getId())));
        SfaAuditTransregionalRespVo respVo = (SfaAuditTransregionalRespVo)CrmBeanUtil.copy((Object)((Object)sfaAuditTransregionalEntity), SfaAuditTransregionalRespVo.class);
        return respVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(SfaAuditTransregionalReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getAuditAccount(), (String)"\u767b\u5f55\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        reqVo.setAuditCode(CodeUtil.createCode());
        Map<String, String> areaInfo = new AuditAccountUtils().getAreaInfo(reqVo.getAuditAccount());
        SfaAuditTransregionalEntity entity = (SfaAuditTransregionalEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaAuditTransregionalEntity.class));
        entity.setAuditAreaCode(areaInfo.get("code"));
        entity.setAuditArea(areaInfo.get("name"));
        this.save((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(SfaAuditTransregionalReqVo reqVo) {
        SfaAuditTransregionalEntity entity = (SfaAuditTransregionalEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        this.updateById((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(SfaAuditTransregionalReqVo reqVo) {
        List sfaAuditTransregionalEntities = this.sfaAuditTransregionalMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaAuditTransregionalEntities)) {
            sfaAuditTransregionalEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
        }
        this.updateBatchById(sfaAuditTransregionalEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(SfaAuditTransregionalReqVo reqVo) {
        List sfaAuditTransregionalEntities = this.sfaAuditTransregionalMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaAuditTransregionalEntities)) {
            sfaAuditTransregionalEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(sfaAuditTransregionalEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(SfaAuditTransregionalReqVo reqVo) {
        List sfaAuditTransregionalEntities = this.sfaAuditTransregionalMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaAuditTransregionalEntities)) {
            sfaAuditTransregionalEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(sfaAuditTransregionalEntities);
    }

    @Override
    public List<SfaAuditTransregionalRespVo> queryTransregionalAudit(SfaAuditTransregionalReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getTerminalCode(), (String)"\u7ec8\u7aef\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        List<SfaAuditTransregionalRespVo> respVos = this.sfaAuditTransregionalMapper.queryAuditByTerminalCode(reqVo);
        return respVos;
    }

    @Override
    public SfaAuditTransregionalRespVo queryTransregionalAuditDetail(SfaAuditTransregionalReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getAuditCode(), (String)"\u7a3d\u67e5\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        SfaAuditTransregionalRespVo respVo = this.sfaAuditTransregionalMapper.queryAuditByAuditCode(reqVo);
        return respVo;
    }
}

