/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.map.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.resttemplate.RestTemplateUtils;
import com.biz.crm.map.mapper.SfaTencentMapDataMapper;
import com.biz.crm.map.model.SfaTencentMapDataEntity;
import com.biz.crm.map.model.req.SfaCoordinatesDetermineReqVO;
import com.biz.crm.map.model.req.SfaSalesFenceReqVO;
import com.biz.crm.map.model.req.SfaTencentMapData;
import com.biz.crm.map.model.resp.SfaTencentMapDataRespVo;
import com.biz.crm.map.service.SfaTencentMapDataService;
import com.biz.crm.mdm.terminal.MdmTerminalFeign;
import com.biz.crm.nebular.mdm.terminal.MdmTencentMapData;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
@Transactional
public class SfaTencentMapDataServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SfaTencentMapDataMapper, SfaTencentMapDataEntity>
implements SfaTencentMapDataService {
    private static final Logger log = LoggerFactory.getLogger(SfaTencentMapDataServiceImpl.class);
    @Resource
    private SfaTencentMapDataMapper sfaTencentMapDataMapper;
    @Resource
    private MdmTerminalFeign mdmTerminalFeign;
    @Value(value="${tencent.a-fence}")
    private String coordinatesDetermine;
    @Value(value="${tencent.sales-fence}")
    private String salesFence;
    @Value(value="${tencent.key}")
    private String key;

    @Override
    public void save(List<SfaTencentMapDataEntity> reqVo) {
        HashSet data = new HashSet();
        reqVo.forEach(o -> {
            if (StringUtils.isEmpty((String)o.getMapId()) || StringUtils.isEmpty((String)o.getLongitude()) || StringUtils.isEmpty((String)o.getLatitude()) || StringUtils.isEmpty((String)o.getName())) {
                return;
            }
            data.add(o);
        });
        ArrayList entities = Lists.newArrayList(data);
        List idList = entities.stream().map(SfaTencentMapDataEntity::getMapId).collect(Collectors.toList());
        ((LambdaUpdateChainWrapper)this.lambdaUpdate().in(SfaTencentMapDataEntity::getMapId, idList)).remove();
        List sfaTencentMapDataEntities = CrmBeanUtil.copyList((List)entities, SfaTencentMapDataEntity.class);
        this.saveBatch(sfaTencentMapDataEntities);
    }

    @Override
    public Result saveTxMapData(SfaTencentMapData sfaTencentMapData) {
        List<SfaTencentMapData.SfaTencentMapDataReqVo> data = sfaTencentMapData.getData();
        MdmTencentMapData mdmTencentMapData = new MdmTencentMapData();
        ArrayList<MdmTencentMapData.MdmTencentMapDataReqVo> mdm = new ArrayList<MdmTencentMapData.MdmTencentMapDataReqVo>();
        for (SfaTencentMapData.SfaTencentMapDataReqVo datum : data) {
            MdmTencentMapData.MdmTencentMapDataReqVo toData = new MdmTencentMapData.MdmTencentMapDataReqVo();
            BeanUtils.copyProperties((Object)datum, (Object)toData);
            mdm.add(toData);
        }
        mdmTencentMapData.setData(mdm);
        return this.mdmTerminalFeign.saveTxBatch(mdmTencentMapData);
    }

    @Override
    public PageResult<SfaTencentMapDataRespVo> findList(SfaTencentMapData.SfaTencentMapDataReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaTencentMapDataRespVo> result = this.sfaTencentMapDataMapper.findList((Page<SfaTencentMapDataRespVo>)page, reqVo);
        return PageResult.builder().count(Long.valueOf(page.getTotal())).data(result).build();
    }

    @Override
    public Result qrySalesConsultantFence(SfaCoordinatesDetermineReqVO reqVO) {
        reqVO.setCity(reqVO.getCity());
        reqVO.setDistrict(reqVO.getDistrict());
        reqVO.setProvince(reqVO.getProvince());
        SfaCoordinatesDetermineReqVO.Location location = new SfaCoordinatesDetermineReqVO.Location();
        location.setLat(reqVO.getLocation().getLat());
        location.setLng(reqVO.getLocation().getLng());
        reqVO.setLocation(location);
        reqVO.setKey(this.key);
        JSONObject jsonObject = SfaTencentMapDataServiceImpl.postForObject(RestTemplateUtils.geTemplate(), this.coordinatesDetermine, JSON.parseObject((String)JSON.toJSONString((Object)reqVO)), JSONObject.class, null);
        if (Objects.isNull(jsonObject)) {
            return Result.error((String)"tencent\u63a5\u53e3\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a");
        }
        JSONObject data = jsonObject.getJSONObject("data");
        data = data == null ? new JSONObject() : data;
        String salesConsultantOffline = data.getString("salesConsultantOffline");
        if (StringUtils.isNotEmpty((String)salesConsultantOffline) && salesConsultantOffline.equals(reqVO.getSalesConsultantOffline())) {
            return Result.ok();
        }
        return Result.error((String)"\u5f53\u524d\u7ec8\u7aef\u7f51\u70b9\u672a\u5728\u4f60\u7684\u6240\u5c5e\u7247\u533a\uff0c\u65e0\u6cd5\u8fdb\u884c\u62dc\u8bbf\uff01");
    }

    @Override
    public Result<List<String>> qrySalesFence(SfaSalesFenceReqVO reqVO) {
        reqVO.setKey(this.key);
        JSONObject jsonObject = SfaTencentMapDataServiceImpl.postForObject(RestTemplateUtils.geTemplate(), this.salesFence, JSON.parseObject((String)JSON.toJSONString((Object)reqVO)), JSONObject.class, null);
        ArrayList list = Lists.newArrayList();
        if (Objects.isNull(jsonObject)) {
            return Result.ok((Object)list);
        }
        JSONObject data = jsonObject.getJSONObject("data");
        data = data == null ? new JSONObject() : data;
        String fence = data.getString("fence");
        fence = fence.replace("|", ";");
        String[] split = fence.split(";");
        for (int i = 0; i < split.length; ++i) {
            list.add(split[i]);
        }
        return Result.ok((Object)list);
    }

    public static <T> T postForObject(RestTemplate restTemplate, String url, JSONObject jsonObject, Class<T> responseType, Map<String, Object> params) {
        if (MapUtils.isNotEmpty(params)) {
            List uriParams = params.keySet().stream().map(s -> s + "={" + s + "}").collect(Collectors.toList());
            url = url + "?" + org.apache.commons.lang3.StringUtils.join(uriParams, (String)"&");
        }
        HttpHeaders headers = new HttpHeaders();
        MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
        headers.setContentType(type);
        headers.add("Accept", MediaType.APPLICATION_JSON.toString());
        HttpEntity httpEntity = new HttpEntity((Object)(jsonObject == null ? null : jsonObject.toJSONString()), (MultiValueMap)headers);
        if (MapUtils.isNotEmpty(params)) {
            return (T)restTemplate.postForObject(url, (Object)httpEntity, responseType, params);
        }
        return (T)restTemplate.postForObject(url, (Object)httpEntity, responseType, new Object[0]);
    }
}

