/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mqconsumer;

import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.moblie.controller.visit.req.GetVisitListReq;
import com.biz.crm.mq.AbstractRocketMQConsumer;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.service.RedisService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoRedisData;
import com.biz.crm.visitinfo.req.PlanInfoSettlementReq;
import com.biz.crm.visitinfo.service.ISfaVisitPlanInfoService;
import java.time.LocalDate;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.rocketmq.spring.annotation.ConsumeMode;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@RocketMQMessageListener(topic="${rocketmq.topic}${rocketmq.environment-variable}", selectorExpression="VISIT_PLAN_INFO_SETTLEMENT", consumerGroup="VISIT_PLAN_INFO_SETTLEMENT${rocketmq.environment-variable}", consumeMode=ConsumeMode.CONCURRENTLY)
public class VisitPlanInfoSettlementConsumer
extends AbstractRocketMQConsumer {
    private static final Logger log = LoggerFactory.getLogger(VisitPlanInfoSettlementConsumer.class);
    @Resource
    private RedisService redisService;
    @Resource
    private ISfaVisitPlanInfoService sfaVisitPlanInfoService;

    protected Object handleMessage(RocketMQMessageBody message) {
        String msgBody = message.getMsgBody();
        PlanInfoSettlementReq req = (PlanInfoSettlementReq)JsonPropertyUtil.toObject((String)msgBody, PlanInfoSettlementReq.class);
        List<PlanInfoSettlementReq.VisitUserPosition> users = req.getVisitUserPositionList();
        if (CollectionUtil.listNotEmptyNotSizeZero(users)) {
            users.forEach(x -> {
                PlanInfoSettlementReq settlementReq = new PlanInfoSettlementReq();
                settlementReq.setVisitDate(req.getVisitDate());
                settlementReq.setVisitPositionCode(x.getVisitPositionCode());
                settlementReq.setVisitUserName(x.getVisitUserName());
                this.planInfoSettlement(settlementReq);
            });
        }
        return "\u7ed3\u7b97\u5b8c\u6210";
    }

    protected void planInfoSettlement(PlanInfoSettlementReq req) {
        List<SfaVisitPlanInfoEntity> planInfoEntities = this.loadUserVisitPlan(req);
        for (SfaVisitPlanInfoEntity planInfoEntity : planInfoEntities) {
            SfaVisitPlanInfoRedisData sfaVisitPlanInfoRedisData = null;
            if (this.hasRedisData(planInfoEntity)) {
                sfaVisitPlanInfoRedisData = (SfaVisitPlanInfoRedisData)this.redisService.hmget(SfaVisitPlanInfoRedisData.getInstance().redisHash(planInfoEntity.getVisitDate(), planInfoEntity.getVisitUserName(), planInfoEntity.getVisitPosCode(), planInfoEntity.getVisitBigType()).toString(), (Object)planInfoEntity.getRedisHashKey());
            }
            this.sfaVisitPlanInfoService.dataDurability(planInfoEntity, sfaVisitPlanInfoRedisData);
            this.redisService.hmset(planInfoEntity.redisHash(planInfoEntity.getVisitDate(), planInfoEntity.getVisitUserName(), planInfoEntity.getVisitPosCode(), planInfoEntity.getVisitBigType()).toString(), planInfoEntity.buildRedisDataForWrite(), 1296000L);
            if (null == sfaVisitPlanInfoRedisData) continue;
            this.redisService.hmset(sfaVisitPlanInfoRedisData.redisHash(planInfoEntity.getVisitDate(), planInfoEntity.getVisitUserName(), planInfoEntity.getVisitPosCode(), planInfoEntity.getVisitBigType()).toString(), sfaVisitPlanInfoRedisData.buildRedisDataForWrite(), 1296000L);
        }
    }

    protected boolean hasRedisData(SfaVisitPlanInfoEntity planInfoEntity) {
        return SfaVisitEnum.VisitBigType.HELP_VISIT.getVal().equals(planInfoEntity.getVisitBigType()) ? SfaVisitEnum.HelpVisitStatus.NO_COMMIT.getVal().equals(planInfoEntity.getVisitStatus()) : SfaVisitEnum.visitStatus.V5.getVal().equals(planInfoEntity.getVisitStatus());
    }

    protected List<SfaVisitPlanInfoEntity> loadUserVisitPlan(PlanInfoSettlementReq settlementReq) {
        GetVisitListReq req = (GetVisitListReq)CrmBeanUtil.copy((Object)settlementReq, GetVisitListReq.class);
        req.setVisitBigType(SfaVisitEnum.VisitBigType.VISIT.getVal());
        List<SfaVisitPlanInfoEntity> planInfoTemps = this.sfaVisitPlanInfoService.doGetVisitInfoList(req);
        req.setVisitBigType(SfaVisitEnum.VisitBigType.HELP_VISIT.getVal());
        planInfoTemps.addAll(this.sfaVisitPlanInfoService.doGetVisitInfoList(req));
        req.setVisitBigType(SfaVisitEnum.VisitBigType.UNFAMILIAR_VISIT.getVal());
        planInfoTemps.addAll(this.sfaVisitPlanInfoService.doGetVisitInfoList(req));
        List<SfaVisitPlanInfoEntity> planInfoEntities = planInfoTemps.stream().filter(v -> {
            LocalDate date = LocalDate.parse(v.getVisitDate(), CrmDateUtils.yyyyMMdd);
            v.setVisitDateOfYearMonth(date.format(CrmDateUtils.yyyyMM));
            v.setVisitDateOfYear(date.format(CrmDateUtils.yyyy));
            if (SfaVisitEnum.VisitBigType.HELP_VISIT.getVal().equals(v.getVisitBigType())) {
                if (SfaVisitEnum.HelpVisitStatus.READY_HELP_DEFENSE.getVal().equals(v.getVisitStatus())) {
                    v.setVisitStatus(SfaVisitEnum.HelpVisitStatus.ALREADY_OVERDUE.getVal());
                    v.setVisitStatusName(SfaVisitEnum.HelpVisitStatus.ALREADY_OVERDUE.getDesc());
                    return true;
                }
                if (SfaVisitEnum.HelpVisitStatus.IN_HELP_DEFENSE.getVal().equals(v.getVisitStatus())) {
                    v.setVisitStatus(SfaVisitEnum.HelpVisitStatus.NO_COMMIT.getVal());
                    v.setVisitStatusName(SfaVisitEnum.HelpVisitStatus.NO_COMMIT.getDesc());
                    v.setRemarks("\u8be5\u7528\u6237\u5728\u6267\u884c\u4e1a\u52a1\u65f6\u672a\u4e3b\u52a8\u63d0\u4ea4\u6267\u884c\u6570\u636e\uff08\u4efb\u52a1/\u540e\u53f0\u6279\u91cf\u7ed3\u7b97\uff09");
                    return true;
                }
            } else {
                if (SfaVisitEnum.visitStatus.V1.getVal().equals(v.getVisitStatus())) {
                    v.setVisitStatus(SfaVisitEnum.visitStatus.V6.getVal());
                    v.setVisitStatusName(SfaVisitEnum.visitStatus.V6.getDesc());
                    return true;
                }
                if (SfaVisitEnum.visitStatus.V2.getVal().equals(v.getVisitStatus())) {
                    v.setVisitStatus(SfaVisitEnum.visitStatus.V5.getVal());
                    v.setVisitStatusName(SfaVisitEnum.visitStatus.V5.getDesc());
                    v.setRemarks("\u8be5\u7528\u6237\u5728\u6267\u884c\u4e1a\u52a1\u65f6\u672a\u4e3b\u52a8\u63d0\u4ea4\u6267\u884c\u6570\u636e\uff08\u4efb\u52a1/\u540e\u53f0\u6279\u91cf\u7ed3\u7b97\uff09");
                    return true;
                }
            }
            return false;
        }).collect(Collectors.toList());
        return planInfoEntities;
    }
}

