/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.util;

import com.biz.crm.util.DateUtil;
import java.util.Calendar;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateStringUtils {
    private static final Logger log = LoggerFactory.getLogger(DateStringUtils.class);

    public static String getStartTimeByDate(String dateType, String date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(DateUtil.parseDate((String)date, (String)"yyyy-MM-dd"));
        if ("WEEK".equals(dateType)) {
            if (calendar.get(7) == 1) {
                calendar.add(4, -1);
                calendar.add(5, 1);
            } else {
                calendar.set(7, 2);
            }
        } else if ("MONTH".equals(dateType)) {
            calendar.set(5, 1);
        }
        return DateUtil.format((Date)calendar.getTime(), (String)"yyyy-MM-dd");
    }

    public static String getEndTimeByDate(String dateType, String date) {
        Calendar calendar = Calendar.getInstance();
        long time = calendar.getTime().getTime();
        calendar.setTime(DateUtil.parseDate((String)date, (String)"yyyy-MM-dd"));
        if ("WEEK".equals(dateType)) {
            if (calendar.get(7) != 1) {
                calendar.add(4, 1);
                calendar.set(7, 1);
            }
        } else if ("MONTH".equals(dateType)) {
            calendar.add(2, 1);
            calendar.set(5, 1);
            calendar.add(5, -1);
        }
        if (calendar.getTime().getTime() > time) {
            return DateUtil.format((Date)new Date(time), (String)"yyyy-MM-dd");
        }
        return DateUtil.format((Date)calendar.getTime(), (String)"yyyy-MM-dd");
    }

    public static String getMonthTimeByDate(String date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(DateUtil.parseDate((String)date, (String)"yyyy-MM-dd"));
        return DateUtil.format((Date)calendar.getTime(), (String)"yyyy-MM");
    }
}

