/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.visitinfo.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import com.biz.crm.visitinfo.req.RegionalVisitFrequencyReqVo;
import com.biz.crm.visitinfo.req.VisitCompleteInfoSearchReqVo;
import com.biz.crm.visitinfo.resp.report.RegionalVisitFrequencyRespVo;
import com.biz.crm.visitinfo.resp.report.SfaVisitCompleteInfoRespVo;
import com.biz.crm.visitinfo.resp.report.SfaVisitRouteRespVo;
import com.biz.crm.visitinfo.service.ISfaVisitCompleteInfoService;
import com.biz.crm.visitinfo.service.ISfaVisitInfoStepFormService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sfaVisitComplete"})
@Api(tags={"\u62dc\u8bbf\u5b8c\u6210\u8fdb\u5ea6\u62a5\u8868 "})
public class SfaVisitCompleteController {
    private static final Logger log = LoggerFactory.getLogger(SfaVisitCompleteController.class);
    @Resource
    private ISfaVisitCompleteInfoService sfaVisitCompleteInfoService;
    @Autowired
    private ISfaVisitInfoStepFormService sfaVisitInfoStepFormService;

    @ApiOperation(value="\u67e5\u8be2\u62dc\u8bbf\u5b8c\u6210\u62a5\u8868\u2014\u2014\u65e5\u8fdb\u5ea6\u5217\u8868")
    @PostMapping(value={"/getSfaVisitCompleteDailyList"})
    @CrmLog
    public Result<PageResult<SfaVisitCompleteInfoRespVo>> getSfaVisitCompleteDailyList(@RequestBody VisitCompleteInfoSearchReqVo visitCompleteInfoSearchReqVo) {
        PageResult<SfaVisitCompleteInfoRespVo> visitCompleteInfoDailyList = this.sfaVisitCompleteInfoService.getVisitCompleteInfoDailyList(visitCompleteInfoSearchReqVo);
        return Result.ok(visitCompleteInfoDailyList);
    }

    @ApiOperation(value="\u67e5\u8be2\u62dc\u8bbf\u5b8c\u6210\u62a5\u8868\u2014\u2014\u6708\u8fdb\u5ea6\u5217\u8868")
    @PostMapping(value={"/getSfaVisitCompleteMonthList"})
    @CrmLog
    public Result<PageResult<SfaVisitCompleteInfoRespVo>> getSfaVisitCompleteMonthList(@RequestBody VisitCompleteInfoSearchReqVo visitCompleteInfoSearchReqVo) {
        PageResult<SfaVisitCompleteInfoRespVo> visitCompleteInfoDailyList = this.sfaVisitCompleteInfoService.getVisitCompleteInfoMonthList(visitCompleteInfoSearchReqVo);
        return Result.ok(visitCompleteInfoDailyList);
    }

    @ApiOperation(value="\u67e5\u8be2\u62dc\u8bbf\u5b8c\u6210\u62a5\u8868\u2014\u2014\u65e5\u8fdb\u5ea6\u8def\u7ebf\u56fe")
    @GetMapping(value={"/getSfaVisitCompleteDaily"})
    @CrmLog
    public Result<SfaVisitRouteRespVo> getSfaVisitCompleteDaily(@RequestParam(value="date", required=false) String date, @RequestParam(value="posCode", required=false) String posCode) {
        return this.sfaVisitCompleteInfoService.dailyCompleteInfo(date, posCode);
    }

    @ApiOperation(value="\u5237\u65b0\u62dc\u8bbf\u65e5\u8fdb\u5ea6")
    @GetMapping(value={"/planInfoSettlementForWeb"})
    @CrmLog
    public Result planInfoSettlementForWeb(@RequestParam(required=false) String visitDateTemp) {
        this.sfaVisitCompleteInfoService.planInfoSettlementForWeb(visitDateTemp);
        return Result.ok();
    }

    @CrmLog
    @ApiOperation(value="\u89e3\u6790\u62dc\u8bbf\u660e\u7ec6\u6570\u636e\u6b65\u9aa4\u6570\u636e")
    @GetMapping(value={"resolvingVisitPlanInfoStepForm"})
    public Result resolvingVisitPlanInfoStepForm(@RequestParam String visitDate) {
        this.sfaVisitInfoStepFormService.resolvingVisitPlanInfoStepForm(visitDate);
        return Result.ok();
    }

    @GetMapping(value={"brushVisitCompleteInfo"})
    @ApiOperation(value="\u5237\u65b0\u62dc\u8bbf\u7ed3\u7b97\u4efb\u52a1")
    public Result brushVisitCompleteInfo() {
        this.sfaVisitCompleteInfoService.brushVisitCompleteInfo();
        return Result.ok();
    }

    @CrmLog
    @ApiOperation(value="\u533a\u57df\u62dc\u8bbf\u9891\u6b21\u62a5\u8868")
    @PostMapping(value={"regionalVisitFrequency"})
    public Result<PageResult<RegionalVisitFrequencyRespVo>> regionalVisitFrequency(@RequestBody RegionalVisitFrequencyReqVo reqVo) {
        PageResult<RegionalVisitFrequencyRespVo> list = this.sfaVisitCompleteInfoService.regionalVisitFrequency(reqVo);
        return Result.ok(list);
    }
}

