package com.biz.crm.eunm.dms;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2021/3/1 15:03
 **/
public class OrderEunm {


    /**
     * 订单状态
     */
    public enum STATE {
        TOSUBMIT("0", "待提交"),
        TOAPPROVAL("1", "待审批"),
        REJECT("2", "审批驳回"),
        APPROVALADOPT("3", "审批通过"),
        CANCEL("4", "取消（退单）"),
        COMPLETE("5", "完成");

        private String code;
        private String value;

        STATE() {
        }

        STATE(String code, String value) {
            this.code = code;
            this.value = value;
        }

        public String getCode() {
            return code;
        }

        public String getValue() {
            return value;
        }
    }

    /**
     * 订单类型
     */
    public enum TYPE {
        STANDERD("1", "标准订单"),
        EMARKETING("2", "专销订单"),
        CUSTOMIZED("3", "订制订单"),
        RETAIL("4", "零批订单"),
        PROMOTION("5", "促销订单"),
        REBATE("6", "货补单"),
        FREE("7", "免费单");

        private String code;
        private String value;

        TYPE() {
        }

        TYPE(String code, String value) {
            this.code = code;
            this.value = value;
        }

      public static String getNameByCode(String code) {
          TYPE[] types = TYPE.values();
          for(TYPE type : types) {
              if(type.getCode().equals(code)) {
                  return type.getValue();
              }
          }
          return null;
      }

      public String getCode() {
            return code;
        }

        public String getValue() {
            return value;
        }
    }

    /**
     * 订单行项目类型枚举
     */
    public enum LineTypeEnum {

        SOURCE_PRODUCT("0", "本品"),
        GIFT_PRODUCT("1", "赠品"),
        REP_PRODUCT("2", "货补商品"),
        REISSUE_PRODUCT("3", "补货商品"),
        ;


        private String code;
        private String value;

        /**
         * 根据编码获取枚举
         * @param code
         * @return
         */
        public static LineTypeEnum getByCode(String code) {
            LineTypeEnum[] typeEnums = LineTypeEnum.values();
            for(LineTypeEnum lineTypeEnum : typeEnums) {
                if(lineTypeEnum.getCode().equals(code)) {
                    return lineTypeEnum;
                }
            }
            return null;
        }

        LineTypeEnum(String code, String value) {
            this.code = code;
            this.value = value;
        }

        public String getCode() {
            return code;
        }

        public String getValue() {
            return value;
        }
    }

    /**
     * 算价失败提示语类型
     */
    public enum calSucessMsgTypeEnum {

        GLOB("0", "全局"),
        GROUP("1", "分组上"),
        LINE("2", "行上"),
        PROMOTION("3", "促销上");


        private String code;
        private String value;

        calSucessMsgTypeEnum(String code, String value) {
            this.code = code;
            this.value = value;
        }

        public String getCode() {
            return code;
        }

        public String getValue() {
            return value;
        }
    }
}
