package com.biz.crm.eunm.fee;


/**
 * 费用池调整类型枚举
 * 和数据字典 fee_pool_operation_type 对应
 *
 * @Author Tao.Chen
 * @Date 2021/1/20 15:55
 */
public enum FeePoolOperationTypeEnum {

    INIT("1", "期初"),
    MANUAL_ACCOUNT("2", "手动上账"),
    REBATE_ACCOUNT("3", "返利上账"),
    ORDER_BACK("4", "订单回退"),
    MANUAL_INDUCE("5", "手动扣减"),
    ORDER_USE("6", "订单使用"),
    FREEZE("7", "冻结"),
    UNFREEZE("8", "解冻"),
    ACT_ACCOUNT("9", "活动上账"),
    OCCUPY("11", "占用"),
    UNOCCUPY("12", "释放占用"),
    ;

    private String value;
    private String desc;

    FeePoolOperationTypeEnum(String value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public String getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }
}


