package com.biz.crm.eunm;

/**
 * @author ren.gang
 * @ClassName ActivitiEnum.java
 * @Description 工作流相关公用枚举
 * @createTime 2020年11月26日 11:36:00
 */
public class ActivitiEnum {

    /**
     * 流程来源业务系统
     */
    public enum FormTypeEnum {
        SFA("SFA", "sfa系统");

        FormTypeEnum(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }
        String val;
        String desc;
        public String getVal() {
            return val;
        }
        public String getDesc() {
            return desc;
        }
    }

    /**
     * 表单类型
     */
    public enum SfaCostTypeEnum {
        LEAVE("leave", "请假"),
        OVERTIME("overtime", "工作日调整"),
        EXCEPTION("exception", "异常报备");

        SfaCostTypeEnum(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }
        String val;
        String desc;
        public String getVal() {
            return val;
        }
        public String getDesc() {
            return desc;
        }
    }

    /**
     * 表单类型二级编码
     */
    public enum SfaOvertimeSmallTypeEnum {
        NORMAL("normal", "普通工作日调整"),
        LEGAL("legal", "法定节假日调整");

        SfaOvertimeSmallTypeEnum(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }
        String val;
        String desc;
        public String getVal() {
            return val;
        }
        public String getDesc() {
            return desc;
        }
    }

    /**
     * 操作类型
     */
    public enum OperationType {
        ISSUE("BTN_004", "通过"),
        REJECT("BTN_006", "驳回"),
        CANCEl("BTN_017", "追回")
        ;

        OperationType(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }
        String val;
        String desc;
        public String getVal() {
            return val;
        }
        public String getDesc() {
            return desc;
        }
    }

    /**
     * 审核回调-结果类型
     */
    public enum AuditResultType {
        PASS("pass", "通过")
        ,REJECT("reject", "驳回")
        ;

        AuditResultType(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }
        String val;
        String desc;
        public String getVal() {
            return val;
        }
        public String getDesc() {
            return desc;
        }
    }

}
