package com.biz.crm.eunm.mdm;

import java.util.HashMap;
import java.util.Map;


/**
 * 商品单位类型
 *  @author: luoqi
 *  @Date: 2020-11-26 16:26
 *  @version: V1.0
 *  @Description:
 */
public enum ProductUnitEnum {
    product_base_unit("product_base_unit", "基本单位"),
    material_sale_unit("material_sale_unit", "销售单位");
    private String value;
    private String des;

    ProductUnitEnum(String value, String des) {
        this.value = value;
        this.des = des;
    }

    static Map<String, ProductUnitEnum> enumMap = new HashMap<>();

    static {
        for (ProductUnitEnum type : ProductUnitEnum.values()) {
            enumMap.put(type.getValue(), type);
        }
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getDes() {
        return des;
    }

    public void setDes(String des) {
        this.des = des;
    }

    public static ProductUnitEnum getEnum(String value) {
        return enumMap.get(value);
    }

}
