package com.biz.crm.eunm.fee;

import java.math.BigDecimal;

/**
 * 费用池操作类型分组枚举
 * 和数据字典 fee_pool_operation_type_group 对应
 *
 * @Author Tao.Chen
 * @Date 2021/1/20 15:55
 */
public enum FeePoolOperationTypeGroupEnum {

    ADD_TOTAL_AMOUNT("add_total_amount", "增加总金额", BigDecimal.ONE),
    ADD_USABLE_AMOUNT("add_usable_amount", "增加可用金额", BigDecimal.ONE),
    SUBTRACT_USABLE_AMOUNT("subtract_usable_amount", "减少可用金额", new BigDecimal("-1")),
    ;

    private String value;
    private String desc;
    /***权重*/
    private BigDecimal weight;

    FeePoolOperationTypeGroupEnum(String value, String desc, BigDecimal weight) {
        this.value = value;
        this.desc = desc;
        this.weight = weight;
    }

    public String getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }

    public BigDecimal getWeight() {
        return weight;
    }}


