package com.biz.crm.eunm.fee;


import java.math.BigDecimal;

/**
 * 费用池调整类型枚举
 * 和数据字典 fee_pool_operation_type 对应
 *
 * @Author Tao.Chen
 * @Date 2021/1/20 15:55
 */
public enum FeePoolOperationTypeEnum {

    INIT("1", "期初", BigDecimal.ONE, true, false),
    MANUAL_ACCOUNT("2", "手动上账", BigDecimal.ONE, true, false),
    REBATE_ACCOUNT("3", "返利上账", BigDecimal.ONE, true, false),
    ORDER_BACK("4", "订单回退", BigDecimal.ONE, false, true),
    MANUAL_INDUCE("5", "手动扣减", new BigDecimal(-1), false, true),
    ORDER_USE("6", "订单占用", new BigDecimal(-1), false, true),
    FREEZE("7", "冻结", new BigDecimal(-1), false, true),
    UNFREEZE("8", "解冻", new BigDecimal(-1), false, true),
    ;

    private String value;
    private String desc;
    private BigDecimal weight;
    private boolean inAccount;
    private boolean inUse;

    FeePoolOperationTypeEnum(String value, String desc, BigDecimal weight, boolean inAccount, boolean inUse) {
        this.value = value;
        this.desc = desc;
        this.weight = weight;
        this.inAccount = inAccount;
        this.inUse = inUse;
    }

    public String getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }

    public boolean isInAccount() {
        return inAccount;
    }

    public boolean isInUse() {
        return inUse;
    }}


