package com.biz.crm.eunm.fee;


/**
 * 费用池调整类型枚举
 * 和数据字典 fee_pool_operation_type 的扩展字段对应
 *
 * @Author Tao.Chen
 * @Date 2021/1/20 15:55
 */
public enum FeePoolOperationTypeExtendEnum {

    GROUP("group", "分组", null),
    USE_IN_POOL("useInPool", "主表上调整", "2"),
    SHOW_IN_POOL_DETAIL("showInPoolDetail", "在主表下明细表显示", "3"),
    SHOW_IN_POOL_OPERATION("showInPoolOperation", "在主表下操作记录表显示", "4"),
    SHOW_IN_POOL_DETAIL_LOG("showInPoolDetailLog", "主表下明细表下日志显示", "5"),
    SHOW_IN_DETAIL("showInDetail", "独立明细表显示", "6"),
    USE_IN_DETAIL("useInDetail", "独立明细表调整", "7"),
    ;

    private String value;
    private String desc;
    private String queryType;

    FeePoolOperationTypeExtendEnum(String value, String desc, String queryType) {
        this.value = value;
        this.desc = desc;
        this.queryType = queryType;
    }

    public String getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }

    public String getQueryType() {
        return queryType;
    }

    public static String getExtendByQueryType(String queryType) {
        if (queryType != null && !"".equals(queryType)) {
            for (FeePoolOperationTypeExtendEnum item :
                    FeePoolOperationTypeExtendEnum.values()) {
                if (queryType.equals(item.getQueryType())) {
                    return item.getValue();
                }
            }
        }
        return null;
    }
}


