package com.biz.crm.eunm.fee;

import java.math.BigDecimal;

/**
 * 费用池操作类型分组枚举
 * 和数据字典 fee_pool_operation_type_group 对应
 *
 * @Author Tao.Chen
 * @Date 2021/1/20 15:55
 */
public enum FeePoolOperationTypeGroupEnum {

    INIT("init", "总金额增加，使用金额不变，冻结金额不变，可用金额增加", BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ONE),
    USE("use", "总金额不变，使用金额增加，冻结金额不变，可用金额减少", BigDecimal.ZERO, BigDecimal.ONE, BigDecimal.ZERO, new BigDecimal("-1")),
    BACK("back", "总金额不变，使用金额减少，冻结金额不变，可用金额增加", BigDecimal.ZERO, new BigDecimal("-1"), BigDecimal.ZERO, BigDecimal.ONE),
    FREEZE("freeze", "总金额不变，使用金额不变，冻结金额增加，可用金额减少", BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ONE, new BigDecimal("-1")),
    UNFREEZE("unfreeze", "总金额不变，使用金额不变，冻结金额减少，可用金额增加", BigDecimal.ZERO, BigDecimal.ZERO, new BigDecimal("-1"), BigDecimal.ONE),
    ;

    private String value;
    private String desc;
    /***总金额权重*/
    private BigDecimal totalAmountWeight;
    /***使用金额权重*/
    private BigDecimal useAmountWeight;
    /***冻结金额权重*/
    private BigDecimal freezeAmountWeight;
    /***可用金额权重*/
    private BigDecimal usableAmountWeight;

    FeePoolOperationTypeGroupEnum(String value, String desc, BigDecimal totalAmountWeight, BigDecimal useAmountWeight, BigDecimal freezeAmountWeight, BigDecimal usableAmountWeight) {
        this.value = value;
        this.desc = desc;
        this.totalAmountWeight = totalAmountWeight;
        this.useAmountWeight = useAmountWeight;
        this.freezeAmountWeight = freezeAmountWeight;
        this.usableAmountWeight = usableAmountWeight;
    }

    public static FeePoolOperationTypeGroupEnum getEnum(String value) {
        if (value != null && !"".equals(value)) {
            for (FeePoolOperationTypeGroupEnum item :
                    FeePoolOperationTypeGroupEnum.values()) {
                if (value.equals(item.getValue())) {
                    return item;
                }
            }
        }
        return null;
    }

    public String getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }

    public BigDecimal getTotalAmountWeight() {
        return totalAmountWeight;
    }

    public BigDecimal getUseAmountWeight() {
        return useAmountWeight;
    }

    public BigDecimal getFreezeAmountWeight() {
        return freezeAmountWeight;
    }

    public BigDecimal getUsableAmountWeight() {
        return usableAmountWeight;
    }
}


