package com.biz.crm.eunm.fee;


/**
 * 费用池类型
 *
 * @Author Tao.Chen
 * @Date 2021/1/20 15:55
 */
public enum FeePoolTypeEnum {

    DISCOUNT("discount", "折扣费用池"),
    GOODS("goods", "货补费用池"),
    ;

    private String value;
    private String desc;

    public static FeePoolTypeEnum getEnum(String value) {
        if (value != null && !"".equals(value)) {
            for (FeePoolTypeEnum item :
                    FeePoolTypeEnum.values()) {
                if (value.equals(item.getValue())) {
                    return item;
                }
            }
        }
        return null;
    }

    FeePoolTypeEnum(String value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public String getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }

}
