package com.biz.crm.eunm.fee;


/**
 * 费用池调整类型枚举
 * 和数据字典 fee_pool_operation_type 的扩展字段对应
 *
 * @Author Tao.Chen
 * @Date 2021/1/20 15:55
 */
public enum FeePoolOperationTypeExtendEnum {

    GROUP("group", "分组", null),
    ADJUST_POOL("adjust_pool", "主表头调整", "2"),
    ADJUST_POOL_LINE("adjust_pool_line", "主表行调整", "3"),
    ADJUST_POOL_DETAIL("adjust_pool_detail", "明细表头调整", "4"),
    ADJUST_POOL_DETAIL_LINE("adjust_pool_detail_line", "明细表行调整", "5"),
    SHOW_DETAIL("show_detail", "明细表显示", "6"),
    SHOW_DETAIL_USE("show_detail_use", "使用明细表显示", "7"),
    SHOW_OPERATION("show_operation", "操作记录表显示", "8"),
    SHOW_DETAIL_LOG("show_detail_log", "明细操作日志表显示", "9"),
    ;

    private String value;
    private String desc;
    private String queryType;

    FeePoolOperationTypeExtendEnum(String value, String desc, String queryType) {
        this.value = value;
        this.desc = desc;
        this.queryType = queryType;
    }

    public String getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }

    public String getQueryType() {
        return queryType;
    }

    public static String getExtendByQueryType(String queryType) {
        if (queryType != null && !"".equals(queryType)) {
            for (FeePoolOperationTypeExtendEnum item :
                    FeePoolOperationTypeExtendEnum.values()) {
                if (queryType.equals(item.getQueryType())) {
                    return item.getValue();
                }
            }
        }
        return null;
    }
}


