package com.biz.crm.eunm.activiti.act;

import com.alibaba.excel.util.StringUtils;

import java.util.HashMap;
import java.util.Map;

/**
 * 流程绘制 -业务关系类型枚举类
 * @author YuanZiJian
 * @date 2020/12/15 16:33
 * @version: V1.0
 */
public class TaProcessBizRelationEnum {

    /**
     * 业务关系类型
     */
    public enum BizRelationEnum {

        MENU("menu", "菜单"),
        ORG("org", "组织");

        BizRelationEnum(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }
        String val;
        String desc;
        public String getVal() {
            return val;
        }
        public String getDesc() {
            return desc;
        }
    }

    public static enum bpmStatus {
        COMMIT("1", "待提交"),
        APPROVAL("2", "审批中"),
        PASS("3", "审批通过"),
        REJECT("4", "驳回"),
        BACK("5", "流程追回"),
        CLOSE("6", "关闭");

        private String value;
        private String desc;
        static Map<String, TaProcessBizRelationEnum.bpmStatus> enumMap = new HashMap();
        public static String REPLACE = "";

        private bpmStatus(String value, String desc) {
            this.value = value;
            this.desc = desc;
        }

        public String getValue() {
            return this.value;
        }

        public Integer getIntValue() {
            return Integer.valueOf(this.value);
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getDesc() {
            return this.desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }

        public static Map<String, TaProcessBizRelationEnum.bpmStatus> getEnumMap() {
            return enumMap;
        }

        public static String getTheDescBuVal(String val) {
            return enumMap.containsKey(val)?((TaProcessBizRelationEnum.bpmStatus)enumMap.get(val)).getDesc():"";
        }

        public static String replaceStr() {
            TaProcessBizRelationEnum.bpmStatus[] dataDownTypes = values();
            String str = "";

            for(int i = 0; i < dataDownTypes.length; ++i) {
                str = str + dataDownTypes[i].desc + "_" + dataDownTypes[i].value;
                if(i != dataDownTypes.length - 1) {
                    str = str + ",";
                }
            }

            return str;
        }

        static {
            TaProcessBizRelationEnum.bpmStatus[] var0 = values();
            int var1 = var0.length;

            for(int var2 = 0; var2 < var1; ++var2) {
                TaProcessBizRelationEnum.bpmStatus type = var0[var2];
                enumMap.put(type.getValue(), type);
                if(!StringUtils.isEmpty(REPLACE)) {
                    REPLACE = REPLACE + ",";
                }

                REPLACE = REPLACE + type.getDesc() + "_" + type.getValue();
            }

        }
    }

}
