package com.biz.crm.eunm.mdm;

/**
 * 审批配置枚举类
 */
public class MdmApprovalConfig {

    /**
     * 审批类型
     */
    public enum ApprovalType {

        BPM("1", "流程审批"),
        STATUS("2", "状态审批"),
        ;

        private String value;
        private String desc;

        ApprovalType(String value, String desc) {
            this.value = value;
            this.desc = desc;
        }

        public String getValue() {
            return value;
        }

        public String getDesc() {
            return desc;
        }

    }

    /**
     * 控制范围
     */
    public enum ControlScope {

        ALL("all", "全部"),
        PART("part", "范围"),
        ;

        private String value;
        private String desc;

        ControlScope(String value, String desc) {
            this.value = value;
            this.desc = desc;
        }

        public String getValue() {
            return value;
        }

        public String getDesc() {
            return desc;
        }

    }

    /**
     * 条件逻辑运算方式
     */
    public enum ConditionLogicalType {

        AND("and", "与"),
        OR("or", "或"),
        DESIGN("design", "自定义"),
        ;

        private String value;
        private String desc;

        ConditionLogicalType(String value, String desc) {
            this.value = value;
            this.desc = desc;
        }

        public String getValue() {
            return value;
        }

        public String getDesc() {
            return desc;
        }

    }

    /**
     * 字段类型
     */
    public enum FieldType {

        DICTIONARY("dictionary", "数据字典"),
        DATA_SOURCE("data_source", "数据源"),
        DESIGN("design", "自定义"),
        ;

        private String value;
        private String desc;

        FieldType(String value, String desc) {
            this.value = value;
            this.desc = desc;
        }

        public String getValue() {
            return value;
        }

        public String getDesc() {
            return desc;
        }

    }

    /**
     * 字段匹配方式
     */
    public enum FieldCompareType {

        EQ("eq", "等于");

        private String value;
        private String desc;

        FieldCompareType(String value, String desc) {
            this.value = value;
            this.desc = desc;
        }

        public String getValue() {
            return value;
        }

        public String getDesc() {
            return desc;
        }

    }

}
