package com.biz.crm.eunm;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * @author ren.gang
 * @ClassName ActivitiEnum.java
 * @Description 工作流相关公用枚举
 * @createTime 2020年11月26日 11:36:00
 */
public class ActivitiEnum {


    /**
     * 表单枚举
     */
    public enum FormTypeEnum {
        LEAVE("SFA", "leave", "sfa_leave","请假", "SfaWorkSignLeaveEndFeign"),
        OVERTIME("SFA","overtime", "sfa_overtime","工作日调整", "SfaWorkSignOvertimeEndFeign"),
        EXCEPTION("SFA","exception",  "sfa_exception","异常报备", "SfaWorkSignExceptionEndFeign"),
        LEAVECANCEL("SFA", "leaveCancel", "sfa_leave_cancel", "销假", "SfaWorkSignLeaveCancelEndFeign"),
        TRAVEL("SFA", "travel", "sfa_travel", "出差", "SfaWorkSignTravelEndFeign"),
        ORDER("SFA","order","sfa_order","订单","SfaOrderFeign"),
        TERMINAL("SFA","terminal","sfa_terminal","终端审批","SfaTerminalFeign"),
        CUSTOMER("SFA","customer","sfa_customer","客户审批","SfaCustomerFeign");
        ;
        String formType;
        String costType;
        String processKey;
        String title;
        String callBackFeign;
        FormTypeEnum(String formType, String costType, String processKey
                , String title, String callBackFeign) {
            this.formType = formType;
            this.costType = costType;
            this.processKey = processKey;
            this.title = title;
            this.callBackFeign = callBackFeign;
        }

        public String getFormType() {
            return formType;
        }
        public String getCostType() {
            return costType;
        }
        public String getProcessKey() {
            return processKey;
        }
        public String getTitle() {
            return title;
        }
        public String getCallBackFeign() {
            return callBackFeign;
        }
    }


    /**
     * 工作日调整-二级类型
     */
    public enum SfaOvertimeSmallTypeEnum {
        NORMAL("normal", "普通工作日调整"),
        LEGAL("legal", "法定节假日调整");

        SfaOvertimeSmallTypeEnum(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }
        String val;
        String desc;
        public String getVal() {
            return val;
        }
        public String getDesc() {
            return desc;
        }
    }

    /**
     * 获取表单类型
     * @return
     */
    public static String getFormType(){
        for(FormTypeEnum form : FormTypeEnum.values()) {
            return form.getFormType();
        }
        return null;
    }

    /**
     * 获取类型名称
     * @param costType
     * @return
     */
    public static String getTitle(String costType) {
        for(FormTypeEnum form : FormTypeEnum.values()) {
            if(form.getCostType().equals(costType)) {
                return form.getTitle() + "申请";
            }
        }
        return null;
    }

    /**
     * 获取类型名称_无申请后缀
     * @param costType
     * @return
     */
    public static String getTitleByCostType(String costType) {
        for(FormTypeEnum form : FormTypeEnum.values()) {
            if(form.getCostType().equals(costType)) {
                return form.getTitle();
            }
        }
        return null;
    }

    /**
     * 获取CostType
     * @return
     */
    public static List<String> getCostType() {
        Set<String> costTypeSet = new HashSet<>();
        for(FormTypeEnum form : FormTypeEnum.values()) {
            costTypeSet.add(form.getCostType());
        }
        return new ArrayList<>(costTypeSet);
    }

    /**
     * 检查类型
     * @param costType
     */
    public static boolean checkCostType(String costType) {
        return getCostType().stream().anyMatch(e -> e.equals(costType));
    }


    /**
     * 操作类型
     */
    public enum OperationType {
        ISSUE("BTN_004", "通过"),
        REJECT("BTN_006", "驳回"),
        CANCEl("BTN_017", "追回")
        ;

        OperationType(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }
        String val;
        String desc;
        public String getVal() {
            return val;
        }
        public String getDesc() {
            return desc;
        }
    }

    /**
     * 审核回调-结果类型
     */
    public enum AuditResultType {
        PASS("pass", "通过")
        ,REJECT("reject", "驳回")
        ;

        AuditResultType(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }
        String val;
        String desc;
        public String getVal() {
            return val;
        }
        public String getDesc() {
            return desc;
        }
    }

    /**
     * 审批状态_数据字典： approvalState
     */
    public enum approvalState {
        DONE("DONE", "已办"),
        NOT_DONE("NOT_DONE", "待办"),
        SEND("SEND","抄送")
        ;

        approvalState(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }
        String val;
        String desc;
        public String getVal() {
            return val;
        }
        public String getDesc() {
            return desc;
        }
    }

}
