package com.biz.crm.eunm;

import java.util.HashMap;
import java.util.Map;

/**
 * @author jianglong
 * @version V1.0
 * @Package com.biz.crm.eunm
 * @Description: TODO
 * @date 2020/11/25 下午5:10
 */
public class YesNoEnum {
    /**
     * 0 与 1 是否逻辑
     */
    public enum yesNoEnum {
        ZERO("0", "否"), ONE("1", "是"), TWO("2", "默认"), THREE("3", "默认"),YES("Y", "是"), NO("N", "否"), Y("Y", "有"), N("N", "无")
        ,yes("yes", "是"), no("no", "否");
        private String value;
        private String des;

        yesNoEnum(String value, String des) {
            this.value = value;
            this.des = des;
        }

        static Map<String, yesNoEnum> enumMap = new HashMap<>();

        static {
            for (yesNoEnum type : yesNoEnum.values()) {
                enumMap.put(type.getValue(), type);
            }
        }

        public String getValue() {
            return value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getDes() {
            return des;
        }

        public void setDes(String des) {
            this.des = des;
        }

        public static yesNoEnum getEnum(String value) {
            return enumMap.get(value);
        }

        /**
         * 返回yes或no的描述
         * @param value
         * @return
         */
        public static String getYesOrNoDes(String value) {
            if(YES.getValue().equals(value)) {
                return YES.getDes();
            }
            if(NO.getValue().equals(value)) {
                return NO.getDes();
            }
            return null;
        }
    }


    /**
     * 是否 code是数字表现形式
     */
    public enum YesNoCodeNumberEnum {
        NO(0, "否"),
        YES(1, "是");

        private Integer code;
        private String value;

        YesNoCodeNumberEnum() {
        }

        YesNoCodeNumberEnum(Integer code, String value) {
            this.code = code;
            this.value = value;
        }

        public Integer getCode() {
            return code;
        }

        public String getValue() {
            return value;
        }
    }

}
