package com.biz.crm.eunm.dms;

import java.util.ArrayList;
import java.util.List;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2021/3/1 15:03
 **/
public class OrderFeeRateEunm {


    /**
     * 费用池类型
     */
    public enum feeTypeEunm {
        REP("001", "货补"),
        CASH("002", "现金"),
        TOTAL("003", "(货补+现金)汇总");

        private String code;
        private String value;

        feeTypeEunm() {
        }

        feeTypeEunm(String code, String value) {
            this.code = code;
            this.value = value;
        }

        /**
         * 获取非汇总模式的费用类型code集合
         * @return
         */
        public static List<String> getReTotalCodes(){
            List<String> reList = new ArrayList<>();
            reList.add(CASH.getCode());
            reList.add(REP.getCode());
            return reList;
        }

        public String getCode() {
            return code;
        }

        public String getValue() {
            return value;
        }
    }

    /**
     * 维度
     */
    public enum demension {
        PRODUCT("001", "商品"),
        PRODUCTLEVEL("002", "商品层级"),
        CUS("003", "客户"),
        ORG("004", "组织"),
        ORGPRODUCT("005", "组织+商品"),
        ORGPRODUCTLEVEL("006", "组织+商品层级"),
        CUSPRODUCT("007", "客户+商品"),
        CUSPRODUCTLEVEL("008", "客户+商品层级");

        private String code;
        private String value;

        demension() {
        }

        /**
         * 获取现金限制的接口
         * @return
         */
        public static List<String> getCashDemensionCodes(){
            List<String> reList = new ArrayList<>();
            reList.add(CUS.getCode());
            reList.add(ORG.getCode());
            return reList;
        }

        /**
         * 获货补+现金限制的接口
         * @return
         */
        public static List<String> getCashAndRepDemensionCodes(){
            List<String> reList = new ArrayList<>();
            reList.add(CUS.getCode());
            reList.add(ORG.getCode());
            return reList;
        }

        demension(String code, String value) {
            this.code = code;
            this.value = value;
        }

        public String getCode() {
            return code;
        }

        public String getValue() {
            return value;
        }
    }
}
