package com.biz.crm.eunm.dms;

import java.util.Objects;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/9/15 16:23
 **/
public class SaleGoalEunm {

  /**
   * 根据编码获取枚举
   * @param code
   * @return
   */
  public static ObjectType getObjectTypeByCode(Integer code) {
    ObjectType[] types = ObjectType.values();
    for (ObjectType type : types) {
      if (type.getCode().equals(code)) {
        return type;
      }
    }
    return null;
  }

  /**
   * 根据编码获取任务类型枚举
   * @param code
   * @return
   */
  public static TaskType getTaskTypeByCode(Integer code) {
    TaskType[] types = TaskType.values();
    for(TaskType type : types) {
      if(type.getCode().equals(code)) {
        return type;
      }
    }
    return null;
  }

  /**
   * 根据编码获取枚举{@link SharingType}
   * @param code
   * @return
   */
  public static SharingType getSharingTypeByCode(String code) {
    SharingType[] types = SharingType.values();
    for (SharingType type : types) {
      if(Objects.equals(type.getCode(), code)) {
        return type;
      }
    }
    return null;
  }

  /**
   * 销量目标类型
   */
  public enum GoalType {
    ROUTINE(0, "常规"),
    GOODS(1, "单品"),
    PRODUCT_LEVEL(2, "系列");

    private Integer code;
    private String value;

    GoalType() {
    }

    GoalType(Integer code, String value) {
      this.code = code;
      this.value = value;
    }

    public Integer getCode() {
      return code;
    }

    public String getValue() {
      return value;
    }
  }

  /**
   * 对象维度枚举
   */
  public enum ObjectType {
    CUSTOMER(1, "客户维度"),
    ORGANIZATION(2, "组织维度"),
    TERMINAL(3, "终端维度"),
    ;

    private Integer code;
    private String value;

    ObjectType(Integer code, String value) {
      this.code = code;
      this.value = value;
    }

    public Integer getCode() {
      return code;
    }

    public String getValue() {
      return value;
    }
  }

  /**
   * 任务类型枚举
   */
  public enum TaskType {
    YEARLY(1, "年度"),
    QUARTER(2, "季度"),
    MONTHLY(3, "月度"),
    ;

    private Integer code;
    private String value;

    TaskType(Integer code, String value) {
      this.code = code;
      this.value = value;
    }

    public Integer getCode() {
      return code;
    }

    public String getValue() {
      return value;
    }
  }

  /**
   * 销量目标分摊类型
   */
  public enum SharingType {

    NONE("none", "不分摊"),
    QUARTERLY("quarterly", "分摊到季度"),
    MONTHLY("monthly", "分摊到月度"),
    ;

    private String code;
    private String value;

    SharingType(String code, String value) {
      this.code = code;
      this.value = value;
    }

    public String getCode() {
      return code;
    }

    public String getValue() {
      return value;
    }
  }
}
