package com.biz.crm.sqlupdate;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * @author jianglong
 * @version V1.0
 * @Package com.biz.crm.sqlupdate
 * @Description: TODO
 * @date 2021/3/16 下午3:57
 */
@Target({ElementType.FIELD})
@Retention(RetentionPolicy.RUNTIME)
public @interface CrmColumn {
    String name() ;

    boolean unique() default false;

    boolean nullable() default true;

    int length() default 255;

    /**
     * oracle 类型
     * @return
     */
    String oracleType() default "VARCHAR2";
    String mysqlType() default "VARCHAR";
    String note() default "";

}
