package com.biz.crm.eunm.dms;


/**
 * 政策枚举
 *  @author: luoqi
 *  @Date: 2020-12-2 16:25
 *  @version: V1.0
 *  @Description:
 */
public class PromotionPolicyEunm {
    public static final String dict_type_as_promotion_policy_status = "promotion_policy_status";
    public static final String dict_type_as_promotion_product_type = "promotion_product_type";

    /**
     * 政策状态
     * 待执行：waiting，执行中：running，已结束：finished， 已禁用 ：003
     */
    public enum PromotionPolicyStatusEunm {
        WAITING("waiting", "待执行"),
        RUNNING("running", "执行中"),
        FINISHED("finished", "已结束"),
        DISABLE("003", "已禁用");

        private String code;
        private String value;


        PromotionPolicyStatusEunm(String code, String value) {
            this.code = code;
            this.value = value;
        }



        public String getCode() {
            return code;
        }

        public String getValue() {
            return value;
        }
    }

    /**
     * 促销商品类型
     */
    public enum PromotionProductTypeEunm {
        /** 仅含本品 **/
        CURRENT_ONLY("0", "仅含本品"),
        /** 任意本品和赠品,自由组合 **/
        FREE("1", "任意本品和赠品"),
        /** 本品赠品一一对应 **/
        CURRENT_RELATIONAL_GIFT("2", "本品赠品一一对应"),
        /** 本品即赠品 **/
        CURRENT_GIFT("3", "本品即赠品");

        private String code;
        private String value;


        PromotionProductTypeEunm(String code, String value) {
            this.code = code;
            this.value = value;
        }



        public String getCode() {
            return code;
        }

        public String getValue() {
            return value;
        }
    }


    /**
     * 政策状态
     * 待执行：waiting，执行中：running，已结束：finished， 已禁用 ：003
     */
    public enum PromotionTypeEunm {
        BUYGIFT("0", "买赠"),
        FULLREDUCTION("1", "满减"),
        DISCOUNT("2", "打折"),
        SPECIALPRICE("3", "特价");

        private String code;
        private String value;


        PromotionTypeEunm(String code, String value) {
            this.code = code;
            this.value = value;
        }



        public String getCode() {
            return code;
        }

        public String getValue() {
            return value;
        }
    }

}
