package com.biz.crm.eunm.activiti;

import io.swagger.annotations.ApiModelProperty;

import java.util.Objects;

/**
 * @author jianglong
 * @version V1.0
 * @Package com.biz.crm.eunm.activiti
 * @Description: TODO
 * @date 2020/12/15 下午1:25
 */
public enum ActivitiOperateTypeEnum {
    START("0","发起流程"),
    PREPARE("1","待提交"),
    COMMIT("2","审批中"),
    PASS("3","审批通过"),
    REJECT("4","驳回"),
    RECOVER("5","追回"),

    COMMUNICATE("6","沟通"),
    CONFIRM_COMMUNICATE("7","确认沟通"),
    DELEGATE("8","委派/转办"),
    COPY("9","抄送"),

            ;
    private String code;
    private String desc;

    ActivitiOperateTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }
    /**
     *根据编码返回流程状态名称
     * @param code
     * @return
     */
    public static String getStatusNameByCode(String code) {
        if(Objects.nonNull(code)){
            ActivitiOperateTypeEnum[] values = ActivitiOperateTypeEnum.values();
            for (ActivitiOperateTypeEnum statusEnum : values){
                if(statusEnum.getCode().equals(code)){
                    return statusEnum.getDesc();
                }
            }
        }
        return null;
    }
    /**
     *根据编码校验状态值是否存在
     * @param code
     * @return
     */
    public static boolean checkCodeExist(String code) {

        ActivitiOperateTypeEnum[] values = ActivitiOperateTypeEnum.values();
        for (ActivitiOperateTypeEnum statusEnum : values){
            if(statusEnum.getCode().equals(code)){
                return true;
            }
        }
        return false;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
