package com.biz.crm.eunm.dms;

import java.util.ArrayList;
import java.util.List;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/9/25 17:49
 **/
public class AvailableListRuleEunm {

    /**
     * 维度
     */
    public enum Dimension {
        CUSORG(0, "组织(客户)"),
        CUS(1, "客户"),
        TERMINALORG(2, "组织(终端)"),
        TERMINAL(3, "终端");

        private Integer code;
        private String value;

        Dimension() {
        }

        Dimension(Integer code, String value) {
            this.code = code;
            this.value = value;
        }

        /**
         * 获取客户相关维度的codes
         * @return
         */
        public static List<Integer> getCusTypeCodes(){
           List<Integer> reList = new ArrayList<>(2);
           reList.add(CUSORG.getCode());
           reList.add(CUS.getCode());
           return reList;
        }

        /**
         * 获取终端相关维度的codes
         * @return
         */
        public static List<Integer> getTerminalTypeCodes(){
            List<Integer> reList = new ArrayList<>(2);
            reList.add(TERMINALORG.getCode());
            reList.add(TERMINAL.getCode());
            return reList;
        }

        public static Dimension getByCode(Integer code){
            if(null == code){
                return null;
            }
            if(0 == code.intValue()){
                return CUSORG;
            }
            if(1 == code.intValue()){
                return CUS;
            }
            if(2 == code.intValue()){
                return TERMINALORG;
            }
            if(3 == code.intValue()){
                return TERMINAL;
            }
            return null;
        }

        public Integer getCode() {
            return code;
        }

        public String getValue() {
            return value;
        }
    }
}
