package com.biz.crm.eunm.dms;

/**
 * @Description:
 * @Author zhangyang
 * @Date 2021/5/19
 */
public class ComplaintsEunm {

    /**
     * 投诉建议类型
     */
    public enum ComplaintsTypeEnum {
        PRODUCT(0, "产品质量投诉"),
        PRICE(1, "价格投诉"),
        SERVE(2, "服务质量投诉"),
        CHANNEL(3, "渠道问题反馈"),
        ITPROBLEM(4, "IT类问题"),
        RESTS(5, "其他问题"),
        SUGGEST(6, "建议");

    private Integer code;
    private String value;

    ComplaintsTypeEnum() {
    }

    ComplaintsTypeEnum(Integer code, String value) {
        this.code = code;
        this.value = value;
    }

    public Integer getCode() {
        return code;
    }

    public String getValue() {
        return value;
    }

    }

    /**
     * 投诉建议状态
     */
    public enum ComplaintsStatusEnum {
        FACTORY(0, "待厂家处理"),
        CUSTOMER(1, "待客户回复"),
        FINISHED(2, "已解决");

        private Integer code;
        private String value;

        ComplaintsStatusEnum() {
        }

        ComplaintsStatusEnum(Integer code, String value) {
            this.code = code;
            this.value = value;
        }

        public Integer getCode() {
            return code;
        }

        public String getValue() {
            return value;
        }
    }

    /**
     * 投诉建议回复人类型
     */
    public enum ComplaintsSubTypeEnum {
        FACTORY(0, "厂家"),
        CUSTOMER(1, "客户");

        private Integer code;
        private String value;

        ComplaintsSubTypeEnum() {
        }

        ComplaintsSubTypeEnum(Integer code, String value) {
            this.code = code;
            this.value = value;
        }

        public Integer getCode() {
            return code;
        }

        public String getValue() {
            return value;
        }
    }
}
