package com.biz.crm.eunm.fee;

import java.math.BigDecimal;

/**
 * 费用池操作类型分组枚举
 * 和数据字典 fee_pool_operation_type_group 对应
 *
 * @Author Tao.Chen
 * @Date 2021/1/20 15:55
 */
public enum FeePoolOperationTypeGroupEnum {

    ACCOUNT("account", "上账类", "总金额增加，使用金额不变，冻结金额不变，占用金额不变，可用金额增加", BigDecimal.ONE),
    USE("use", "使用扣减类", "总金额不变，使用金额增加，冻结金额不变，占用金额不变，可用金额减少", BigDecimal.ONE.negate()),
    BACK("back", "回退类", "总金额不变，使用金额减少，冻结金额不变，占用金额不变，可用金额增加", BigDecimal.ONE),
    FREEZE("freeze", "冻结类", "总金额不变，使用金额不变，冻结金额增加，占用金额不变，可用金额减少", BigDecimal.ONE.negate()),
    UNFREEZE("unfreeze", "解冻类", "总金额不变，使用金额不变，冻结金额减少，占用金额不变，可用金额增加", BigDecimal.ONE),
    OCCUPY("occupy", "占用", "总金额不变，使用金额不变，冻结金额不变，占用金额增加，可用金额减少", BigDecimal.ONE.negate()),
    UNOCCUPY("unoccupy", "释放占用", "总金额不变，使用金额不变，冻结金额不变，占用金额减少，可用金额增加", BigDecimal.ONE),
    ;

    private String value;
    private String desc;
    private String text;
    /***可用金额权重*/
    private BigDecimal usableAmountWeight;

    FeePoolOperationTypeGroupEnum(String value, String desc, String text, BigDecimal usableAmountWeight) {
        this.value = value;
        this.desc = desc;
        this.text = text;
        this.usableAmountWeight = usableAmountWeight;
    }

    public static FeePoolOperationTypeGroupEnum getEnum(String value) {
        if (value != null && !"".equals(value)) {
            for (FeePoolOperationTypeGroupEnum item :
                    FeePoolOperationTypeGroupEnum.values()) {
                if (value.equals(item.getValue())) {
                    return item;
                }
            }
        }
        return null;
    }

    public String getValue() {
        return value;
    }

    public String getText() {
        return text;
    }

    public String getDesc() {
        return desc;
    }

    public BigDecimal getUsableAmountWeight() {
        return usableAmountWeight;
    }
}


