package com.biz.crm.eunm.log;

/**
 * @Description:日志
 * @Author: zhangyuzhu
 * @Date: 2020/12/16 18:22
 **/
public class LogEunm {

    /**
     * 日志操作
     */
    public enum OperationTypeEunm {
        ADD(0, "新增"),
        DEL(1, "删除"),
        UPDATE(2, "修改");

        private Integer code;
        private String value;

        OperationTypeEunm() {
        }

        //根据传进来的code动态返回msg
        public static String getDesByCode(Integer code) {
            if (OperationTypeEunm.ADD.getCode().equals(code)) {
                return OperationTypeEunm.ADD.value;
            } else if (OperationTypeEunm.UPDATE.getCode().equals(code)) {
                return OperationTypeEunm.UPDATE.value;
            }else {
                return OperationTypeEunm.UPDATE.value;
            }
        }

        OperationTypeEunm(Integer code, String value) {
            this.code = code;
            this.value = value;
        }

        public Integer getCode() {
            return code;
        }

        public String getValue() {
            return value;
        }
    }


    /**
     * 字段类型分类
     */
    public enum HostTypeEunm {
        BASIC(0, "基本字段"),
        ONE2ONE(1, "一对一"),
        ONE2MANY(2, "一对多");

        private Integer code;
        private String value;

        HostTypeEunm() {
        }

        HostTypeEunm(Integer code, String value) {
            this.code = code;
            this.value = value;
        }

        public Integer getCode() {
            return code;
        }

        public String getValue() {
            return value;
        }
    }
}
