package com.biz.crm.eunm.mdm;

/**
 * 审批配置枚举类
 */
public class MdmApprovalConfig {

    /**
     * 控制范围
     * 对应数据字典：mdm_approval_control_scope
     */
    public enum ControlScope {

        ALL_IN("all_in", "全部审批"),
        ALL_OUT("all_out", "全部不审批"),
        PART_IN_CONDITION("part_in_condition", "满足条件需要审批，其余无需审批"),
        PART_OUT_CONDITION("part_out_condition", "满足条件无需审批，其余需要审批"),
        ;

        private String value;
        private String desc;

        ControlScope(String value, String desc) {
            this.value = value;
            this.desc = desc;
        }

        public String getValue() {
            return value;
        }

        public String getDesc() {
            return desc;
        }

    }

    /**
     * 条件运算方式
     * 对应数据字典：mdm_approval_group_check_way
     */
    public enum GroupCheckWay {

        ALL_CONDITION("all_condition", "全部业务数据条件成立"),
        ONE_CONDITION("one_condition", "至少一个业务数据条件成立"),
        ALL_SUBMITTER("all_submitter", "全部提交人条件成立"),
        ONE_SUBMITTER("one_submitter", "至少一个提交人条件成立"),
        ALL_CONDITION_AND_ALL_SUBMITTER("all_condition_and_all_submitter", "全部业务数据条件成立，并且全部提交人条件成立"),
        ONE_CONDITION_AND_ONE_SUBMITTER("one_condition_and_one_submitter", "至少一个业务数据条件成立，并且且至少一个提交人条件成立"),
        ALL_CONDITION_OR_ALL_SUBMITTER("all_condition_or_all_submitter", "全部业务数据条件成立，或者全部提交人条件成立"),
        ONE_CONDITION_OR_ONE_SUBMITTER("one_condition_or_one_submitter", "至少一个业务数据条件成立，或者至少一个提交人条件成立"),
        ;

        private String value;
        private String desc;

        public static GroupCheckWay getEnum(String value) {
            if (value != null) {
                for (GroupCheckWay item :
                        GroupCheckWay.values()) {
                    if (item.getValue().equals(value)) {
                        return item;
                    }
                }
            }
            return null;
        }

        GroupCheckWay(String value, String desc) {
            this.value = value;
            this.desc = desc;
        }

        public String getValue() {
            return value;
        }

        public String getDesc() {
            return desc;
        }

    }

    /**
     * 字段类型
     * 对应数据字典：mdm_approval_field_type
     */
    public enum FieldType {

        DICTIONARY("dictionary", "数据字典"),
        DATA_SOURCE("data_source", "数据源"),
        DESIGN("design", "自定义"),
        ;

        private String value;
        private String desc;

        FieldType(String value, String desc) {
            this.value = value;
            this.desc = desc;
        }

        public String getValue() {
            return value;
        }

        public String getDesc() {
            return desc;
        }

    }

    /**
     * 字段匹配方式
     * 对应数据字典：mdm_approval_field_compare_type
     */
    public enum FieldCompareType {

        EQ("eq", "等于"),
        NE("ne", "不等于"),
        ;

        private String value;
        private String desc;

        FieldCompareType(String value, String desc) {
            this.value = value;
            this.desc = desc;
        }

        public String getValue() {
            return value;
        }

        public String getDesc() {
            return desc;
        }

    }

    /**
     * 提交人匹配对象
     * 对应数据字典：mdm_approval_submitter_type
     */
    public enum SubmitterType {

        ROLE("role", "权限角色"),
        POSITION("position", "职位"),
        ORG("org", "组织"),
        ;

        private String value;
        private String desc;

        SubmitterType(String value, String desc) {
            this.value = value;
            this.desc = desc;
        }

        public String getValue() {
            return value;
        }

        public String getDesc() {
            return desc;
        }

    }

    /**
     * 提交人匹配方式
     * 对应数据字典：mdm_approval_submitter_type
     */
    public enum SubmitterCompareType {

        EQ("eq", "等于"),
        NE("ne", "不等于"),
        IN_CHILDREN("in_children", "当前下级"),
        IN_PARENT("in_parent", "当前上级"),
        NOT_IN_CHILDREN("not_in_children", "不属于下级"),
        NOT_IN_PARENT("not_in_parent", "不属于上级"),
        ;

        private String value;
        private String desc;

        SubmitterCompareType(String value, String desc) {
            this.value = value;
            this.desc = desc;
        }

        public String getValue() {
            return value;
        }

        public String getDesc() {
            return desc;
        }
    }

}
