package com.biz.crm.eunm.sfa;

/**
 * @author ren.gang
 * @ClassName WorkSignEnum.java
 * @Description 考勤规则枚举
 * @createTime 2020年11月30日 17:07:00
 */
public class WorkSignEnum {

    /**
     * 打卡或不打卡类型
     */
    public enum signOrNonType{
        WORKDAY_SIGN("10", "工作日打卡"),
        SPECIAL_DAY_SIGN("11", "特殊日期打卡"),
        WORK_DAY_NO_SIGN("20", "非工作日不打卡"),
        SPECIAL_DAY_NO_SIGN("21","特殊日期不打卡"),
        HOLIDAY_NO_SIGN("22", "节假日不打卡");

        private String value;
        private String des;
        signOrNonType(String value, String des) {
            this.value = value;
            this.des = des;
        }

        public String getValue() {
            return value;
        }

        public String getDes() {
            return des;
        }
    }

    /**
     * 考勤相关申请类型
     */
    public enum signApplyType {
        LEAVE("leave", "请假")
        ,EXCEPTION("exception", "异常报备")
        ;
        private String value;
        private String des;
        signApplyType(String value, String des) {
            this.value = value;
            this.des = des;
        }

        public String getValue() {
            return value;
        }

        public String getDes() {
            return des;
        }
    }



    /**
     * 时间类型
     */
    public enum TimeType {
        JT("jt","今天"),
        BZ("bz", "本周"),
        BY("by", "本月"),
        SY("sy", "上月");

        TimeType(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }
        String val;
        String desc;
        public String getVal() {
            return val;
        }
        public String getDesc() {
            return desc;
        }
    }
    /**
     * 编码类型
     */
    public enum codeType {
        ORG("org","组织"),
        POS_LEVEL("posLevel", "职位等级"),
        DEALER("dealer","经销商"),
        ROLE("role","角色")
        ;
        codeType(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }
        String val;
        String desc;
        public String getVal() {
            return val;
        }
        public String getDesc() {
            return desc;
        }
    }

    /**
     * 绩效类型
     */
    public enum achievementTimeType {
        MM("MM", "月度"),
        TD("TD", "旬度"),
        SX("SX","上旬"),
        XX("XX","下旬"),
        FT("FT","自由时间");

        achievementTimeType(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }
        String val;
        String desc;
        public String getVal() {
            return val;
        }
        public String getDesc() {
            return desc;
        }
    }

    /**
     * 绩效对象类型
     */
    public enum AchievementObjectType {
        ORG("ORG","组织"),
        USER_POS("USER_POS","用户职位");

        AchievementObjectType(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }
        String val;
        String desc;
        public String getVal() {
            return val;
        }
        public String getDesc() {
            return desc;
        }
    }

    public enum workSignPlaceType {
        VISIT_PLAN_PLACE("同步拜访计划", "同步拜访计划");

        workSignPlaceType(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }
        String val;
        String desc;
        public String getVal() {
            return val;
        }
        public String getDesc() {
            return desc;
        }
    }

    public enum WorkSignTypeEnum {
        NONE(0, "不打卡"),
        SPECIAL_NONE(1, "特殊日期不打卡"),
        SPECIAL_SIGN(2, "特殊日期打卡"),
        HOLIDAY_NONE(3, "节假日不打卡"),
        NONE_WEEKDAY_NONE(4, "非工作日不打卡"),
        WEEKDAY_SIGN(5, "工作日打卡"),
        ;

        private int val;
        private String desc;

        WorkSignTypeEnum(int val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        public int getVal() {
            return val;
        }

        public String getDesc() {
            return desc;
        }
    }
}
