package com.biz.crm.sqlupdate;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * @author jianglong
 * @version V1.0
 * @Package com.biz.crm.sqlupdate
 * @Description: TODO
 * @date 2021/3/16 下午3:57
 */
@Target({ElementType.FIELD})
@Retention(RetentionPolicy.RUNTIME)
public @interface CrmColumn {

    /*** 字段名*/
    String name();

    /*** 是否唯一*/
    boolean unique() default false;

    /*** 是否允许为空*/
    boolean nullable() default true;

    /*** 字段长度*/
    int length() default 255;

    /*** oracle 字段类型*/
    String oracleType() default "VARCHAR2";

    /*** mysql 字段类型*/
    String mysqlType() default "VARCHAR";

    /*** 字段备注*/
    String note() default "";

    /***默认值，字符串需要单引号*/
    String defaultValue() default "";

    /***字段相对顺序，BaseEntity里的字段必须小于0，业务数据字典必须大于0*/
    int order() default 32;

}
