package com.biz.crm.eunm.mdm;

/**
 * 登录类型
 */
public enum LoginFromTypeEnum {

    CONSOLE("console", "后台"),
    APPLET_SFA("applet_sfa", "SFA微信小程序"),
    APPLET_DMS("applet_dms", "经销商系统"),
    APP_DMS("app_dms", "DMS手机APP"),
    OFFICIAL_ACCOUNTS_DMS("official_accounts_dms", "DMS微信公众号"),
    APP_SFA("app_sfa", "SFA手机APP"),
    WEB_DMS("web_dms", "DMS商城"),
    CRONTAB("crontab", "定时任务"),
    TEMPORARY("temporary", "临时用户"),
    EXTERNAL("external", "外部系统认证"),
    UNKNOWN("unknown", "未知来源"),
    APPLET_TERMINAL("applet_terminal", "终端微信小程序"),
    ;

    private String value;
    private String desc;

    public static LoginFromTypeEnum getEnum(String value) {
        if (value != null && !"".equals(value)) {
            for (LoginFromTypeEnum item :
                    LoginFromTypeEnum.values()) {
                if (value.equals(item.getValue())) {
                    return item;
                }
            }
        }
        return null;
    }

    public static String getDesc(String value) {
        LoginFromTypeEnum anEnum = getEnum(value);
        if (anEnum != null) {
            return anEnum.getDesc();
        }
        return null;
    }

    LoginFromTypeEnum(String value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public String getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }

}
