package com.biz.crm.eunm.mdm;

/**
 * 审批类型枚举
 */
public enum ApprovalType {

    NULL("0", "不审批"),
    BPM("1", "流程审批"),
    STATUS("2", "状态审批"),
    ;

    public static ApprovalType getEnum(String value) {
        if (value != null && !"".equals(value)) {
            for (ApprovalType item :
                    ApprovalType.values()) {
                if (value.equals(item.getValue())) {
                    return item;
                }
            }
        }
        return null;
    }

    private String value;
    private String desc;

    ApprovalType(String value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public String getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }

}
