package com.biz.crm.eunm.activiti;

import java.util.Objects;

/**
 * @author jianglong
 * @version V1.0
 * @Package com.biz.crm.eunm.activiti
 * @Description: 流程实例状态(启用,禁用,暂停,结束)
 * @date 2020/12/15 下午1:25
 */
public enum ProcessInstanceStatusEnum {
    ENABLE("enable","启用"),
    DISABLE("disable","禁用"),
    PAUSE("pause","暂停"),
    END("end","结束"),
            ;

    private String code;
    private String desc;

    ProcessInstanceStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }
    /**
     *根据编码返回流程状态名称
     * @param code
     * @return
     */
    public static String getStatusNameByCode(String code) {
        if(Objects.nonNull(code)){
            ProcessInstanceStatusEnum[] values = ProcessInstanceStatusEnum.values();
            for (ProcessInstanceStatusEnum statusEnum : values){
                if(statusEnum.getCode().equals(code)){
                    return statusEnum.getDesc();
                }
            }
        }
        return null;
    }
    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
