package com.biz.crm.eunm.fee;

/**
 * 费用池分组枚举
 * 和数据字典 fee_pool_group 对应
 *
 * @Author Tao.Chen
 * @Date 2021/1/20 15:55
 */
public enum FeePoolGroupEnum {

    DEFAULT("default", "默认"),
    ;

    private String value;
    private String desc;

    FeePoolGroupEnum(String value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static FeePoolGroupEnum getEnum(String value) {
        if (value != null && !"".equals(value)) {
            for (FeePoolGroupEnum item :
                    FeePoolGroupEnum.values()) {
                if (value.equals(item.getValue())) {
                    return item;
                }
            }
        }
        return null;
    }

    public String getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }

}


