package com.biz.crm.eunm.mdm;


/**
 * 数据来源
 *  @author: luoqi
 *  @Date: 2021-5-26 11:28
 *  @version: V1.0
 *  @Description:
 */
public enum SourceType {

    WEB("0", "WEB端"),
    WE_CHAT_APP("10", "微信小程序"),
    ANDROID("20", "安卓"),
    IOS("30", "IOS"),
    ;

    public static SourceType getEnum(String value) {
        if (value != null && !"".equals(value)) {
            for (SourceType item :
                    SourceType.values()) {
                if (value.equals(item.getValue())) {
                    return item;
                }
            }
        }
        return null;
    }

    private String value;
    private String desc;
    public static final String DICT_CODE = "source_type";
    SourceType(String value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public String getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }

}
