package com.biz.crm.eunm.sfa;

import java.util.HashMap;
import java.util.Map;

/**
 * 积分管理相关枚举
 * @author YuanZiJian
 * @date 2021/1/11 15:10
 * @version: V1.0
 */
public class IntegralEnum {

    /**
     * 积分规则——计算规则枚举类型
     */
    public enum taskType{
        SAVE_TERMINAL("save_terminal", "新增终端"),
        CLAIM_TERMINAL("claim_terminal", "认领终端"),
        SFA_STEP_CODE_STOCK("sfa_step_code_stock", "库存盘点"),
        DAY_VISIT_PLAN("day_visit_plan","日拜访计划完成"),
        DAY_HELP_VISIT_PLAN("day_help_visit_plan","日协访计划完成"),
        FINISH_VISIT_PLAN("finish_visit_plan", "月拜访计划完成"),
        FINISH_VISIT_HELP_PLAN("finish_visit_help_plan", "月协访计划完成"),
        MONTH_SIGN("month_sign", "月考勤打卡完成"),
        YEAR_SIGN("year_sign", "年考勤打卡完成"),
        SFA_STEP_CODE_COST("sfa_step_code_cost", "费用活动执行完成"),
        SFA_STEP_CODE_ORDER("sfa_step_code_order", "订单采集"),
        SFA_STEP_CODE_COMPETITOR("sfa_step_code_competitor", "竞品采集"),
        PLANING_VISIT_PLAN("planing_visit_plan", "拜访计划制定"),
        PLANING_HELP_DEFENSE("planing_help_defense", "协访计划制定"),
        SFA_STEP_CODE_DISPLAY("sfa_step_code_display", "陈列活动完成");

        private String value;
        private String des;
        taskType(String value, String des) {
            this.value = value;
            this.des = des;
        }
        public static Map<String, String> GETMAP = new HashMap<>();
        static {
            for (taskType type : taskType.values()) {
                GETMAP.put(type.getValue(), type.getDes());
            }
        }
        public String getValue() {
            return value;
        }

        public String getDes() {
            return des;
        }

    }

    public enum ruleType{
        POS_LEVEL("pos", "职位等级类型"),
        ORG("org", "组织类型");

        private String value;
        private String des;

        ruleType(String value, String des) {
            this.value = value;
            this.des = des;
        }
        public String getValue() {
            return value;
        }

        public String getDes() {
            return des;
        }
    }

    public enum ruleCode{
        INTEGRAL_RULE_CODE("integral_rule_code", "积分规则编码");

        private String value;
        private String des;

        ruleCode(String value, String des) {
            this.value = value;
            this.des = des;
        }
        public String getValue() {
            return value;
        }

        public String getDes() {
            return des;
        }
    }


    public enum orgSearchRange{
        NOW_ORG("now_org", "本部门"),
        ALL_ORG("all_org", "本公司"),
        AFTER_ORG("now_org_type", "当前组织及下级组织");

        private String value;
        private String des;

        orgSearchRange(String value, String des) {
            this.value = value;
            this.des = des;
        }
        public String getValue() {
            return value;
        }

        public String getDes() {
            return des;
        }
    }

}
