package com.biz.crm.config;

import com.github.xiaoymin.swaggerbootstrapui.annotations.EnableSwaggerBootstrapUI;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.ParameterBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.schema.ModelRef;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.service.Parameter;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.ApiSelectorBuilder;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;

/**
 * @author jianglong
 * @version V1.0
 * @Package com.biz.eisp.config
 * @Description: TODO
 * @date 2019/4/14 下午12:08
 */
@Slf4j
@Configuration
@EnableSwagger2
@EnableSwaggerBootstrapUI
public class SwaggerConfig {
    @Value("${swagger.package}")
    private String basePackage ;
    @Value("${swagger.enable}")
    private boolean enableSwagger;
    @Value("${swagger.class.annotation:#{null}}")
    private String classAnnotation;
    @Value("${swagger.method.annotation:#{null}}")
    private String methodAnnotation;

    @Bean
    public Docket createRestApi() {
        ApiSelectorBuilder selectorBuilder = new Docket(DocumentationType.SWAGGER_2)
                .apiInfo(apiInfo())
                .select();
        if (null != methodAnnotation && methodAnnotation.length() > 0){
            //有设置使用注解过滤的话
            try {
                selectorBuilder.apis(RequestHandlerSelectors.withMethodAnnotation((Class<? extends Annotation>) Class.forName(methodAnnotation)));
            } catch (ClassNotFoundException e) {
                log.error(e.getMessage(),e);
            }
        }
        if (null != classAnnotation && classAnnotation.length() > 0){
            //有设置使用注解过滤的话
            try {
                selectorBuilder.apis(RequestHandlerSelectors.withClassAnnotation((Class<? extends Annotation>) Class.forName(classAnnotation)));
            } catch (ClassNotFoundException e) {
                log.error(e.getMessage(),e);
            }
        }
        selectorBuilder.apis(RequestHandlerSelectors.basePackage(basePackage));
        selectorBuilder.paths(PathSelectors.any());
        return selectorBuilder.build()
                .enable(enableSwagger).globalOperationParameters(settoken());
    }
    private List<Parameter> settoken(){
        //header中的ticket参数非必填，传空也可以
        Parameter tokenParam = new ParameterBuilder().name("loginUserToken").description("token 认证码")
                .modelRef(new ModelRef("string")).parameterType("header")
                .required(false).build();
        Parameter menuCodeParam = new ParameterBuilder().name("menu_code_").description("菜单编码")
                .modelRef(new ModelRef("string")).parameterType("header")
                .required(false).build();
        Parameter functionCodeParam = new ParameterBuilder().name("function_code_").description("功能编码")
                .modelRef(new ModelRef("string")).parameterType("header")
                .required(false).build();
        //根据每个方法名也知道当前方法在设置什么参数
        return Lists.newArrayList(tokenParam, menuCodeParam, functionCodeParam);
    }
    private ApiInfo apiInfo() {
        Contact contact=new Contact("博智",
                "http://www.biz-united.com.cn/biz-official/src/index.html","marketing@biz-united.com.cn");
        return new ApiInfoBuilder()
                .title("博智CRM产品API")
                .description("博智CRM产品对外接口")
                .contact(contact)
                .version("1.0.0")
                .build();
    }
}
