/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.act.service.impl;

import com.biz.crm.act.model.TmpActFeeShareEntity;
import com.biz.crm.act.model.TpmActBudgetEntity;
import com.biz.crm.act.model.TpmActDetailEntity;
import com.biz.crm.act.model.TpmActEntity;
import com.biz.crm.act.model.TpmActFileEntity;
import com.biz.crm.act.service.impl.ActServiceHelper;
import com.biz.crm.costtypecategories.model.TpmCostTypeCategoriesEntity;
import com.biz.crm.costtypecategories.model.TpmCostTypeCategoriesFineEntity;
import com.biz.crm.costtypefine.model.TpmCostTypeFineEntity;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.tpm.ActFeeShareTypeEnum;
import com.biz.crm.eunm.tpm.FeeBudgetTypeEnum;
import com.biz.crm.feebudget.model.TpmFeeBudgetDetailsEntity;
import com.biz.crm.feebudget.model.TpmFeeBudgetEntity;
import com.biz.crm.nebular.tpm.act.req.TmpActFeeShareReqVo;
import com.biz.crm.nebular.tpm.act.req.TpmActBudgetReqVo;
import com.biz.crm.nebular.tpm.act.req.TpmActReqVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DateUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActBuilder {
    private static final Logger log = LoggerFactory.getLogger(ActBuilder.class);
    private ActServiceHelper helper;
    private TpmActReqVo reqVo;
    private TpmActEntity actEntity = new TpmActEntity();
    private List<TpmActBudgetEntity> actBudgetEntities = Lists.newArrayList();
    private List<TpmActDetailEntity> actDetailEntities = Lists.newArrayList();
    private List<TmpActFeeShareEntity> shareEntities = Lists.newArrayList();
    private List<TpmActFileEntity> fileEntities = Lists.newArrayList();
    private List<TpmFeeBudgetDetailsEntity> feeBudgetDetailsEntities = Lists.newArrayList();
    private List<TpmFeeBudgetEntity> feeBudgetEntities;
    private List<TpmCostTypeCategoriesEntity> categoriesEntities;
    private List<TpmCostTypeFineEntity> fineEntities;
    private List<TpmCostTypeCategoriesFineEntity> categoriesFineEntities;
    private Map<String, TpmFeeBudgetEntity> feeBudgetEntityMap;
    private Map<String, TpmCostTypeCategoriesEntity> categoriesEntitiesMap;
    private Map<String, TpmCostTypeFineEntity> fineEntitiesMap;
    private Map<String, TpmCostTypeCategoriesFineEntity> categoriesFineEntitiesMap;

    public ActBuilder(ActServiceHelper helper, TpmActReqVo reqVo) {
        this.helper = helper;
        this.reqVo = reqVo;
    }

    public static ActBuilder builder(ActServiceHelper helper, TpmActReqVo reqVo) {
        return new ActBuilder(helper, reqVo);
    }

    public ActBuilder init() {
        Set<String> feeBudgetCodes;
        List<TpmFeeBudgetEntity> feeBudgetEntities;
        if (CollectionUtils.isNotEmpty((Collection)this.reqVo.getBudgetVos()) && CollectionUtils.isNotEmpty(feeBudgetEntities = this.helper.findFeeBudgetByCodes(feeBudgetCodes = this.reqVo.getBudgetVos().stream().map(TpmActBudgetReqVo::getFeeBudgetCode).collect(Collectors.toSet())))) {
            this.feeBudgetEntities = feeBudgetEntities;
        }
        if (CollectionUtils.isNotEmpty((Collection)this.reqVo.getDetailVos())) {
            HashSet categoriesCodes = Sets.newHashSet();
            HashSet fineCodes = Sets.newHashSet();
            this.reqVo.getDetailVos().forEach(o -> {
                AssertUtils.isNotEmpty((String)o.getCategoriesCode(), (String)"\u6d3b\u52a8\u5927\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                AssertUtils.isNotEmpty((String)o.getFineCode(), (String)"\u6d3b\u52a8\u7ec6\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                categoriesCodes.add(o.getCategoriesCode());
                fineCodes.add(o.getFineCode());
            });
            this.categoriesEntities = this.helper.findCategoriesEntitiesByCodes(categoriesCodes);
            this.fineEntities = this.helper.findFineEntitiesByCodes(fineCodes);
            this.categoriesFineEntities = this.helper.findCategoriesFineEntities(categoriesCodes, fineCodes);
        }
        return this;
    }

    public ActBuilder check() {
        this.checkActData();
        this.checkFeeBudgetData();
        this.checkDetailData();
        this.checkShareData();
        return this;
    }

    private void checkActData() {
        AssertUtils.isNotEmpty((String)this.reqVo.getBeginDate(), (String)"\u8bf7\u9009\u62e9\u5f00\u59cb\u65f6\u95f4");
        AssertUtils.isNotEmpty((String)this.reqVo.getEndDate(), (String)"\u8bf7\u9009\u62e9\u7ed3\u675f\u65f6\u95f4");
        AssertUtils.isNotEmpty((String)this.reqVo.getSaveType(), (String)"\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        if (StringUtils.isEmpty((CharSequence)this.reqVo.getEndDateSecond())) {
            this.reqVo.setEndDateSecond("23:59:59");
        }
        if (StringUtils.isEmpty((CharSequence)this.reqVo.getBeginDateSecond())) {
            this.reqVo.setBeginDateSecond("00:00:00");
        }
        AssertUtils.isTrue((StringUtils.compare((String)(this.reqVo.getBeginDate() + this.reqVo.getBeginDateSecond()), (String)(this.reqVo.getEndDate() + this.reqVo.getEndDateSecond())) < 0 ? 1 : 0) != 0, (String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4");
        AssertUtils.isNotEmpty((String)this.reqVo.getActName(), (String)"\u8bf7\u8f93\u5165\u6d3b\u52a8\u540d\u79f0");
        AssertUtils.isNotEmpty((String)this.reqVo.getActType(), (String)"\u8bf7\u9009\u62e9\u6d3b\u52a8\u7c7b\u578b");
    }

    public void checkFeeBudgetData() {
        AssertUtils.isNotNull((Object)this.reqVo.getBudgetVos(), (String)"\u9884\u7b97\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isTrue((this.reqVo.getBudgetVos().size() == this.reqVo.getBudgetVos().size() ? 1 : 0) != 0, (String)"\u4e0d\u80fd\u9009\u62e9\u76f8\u540c\u7684\u8d39\u7528\u9884\u7b97\u6570\u636e");
        AssertUtils.isTrue((this.feeBudgetEntities.size() == this.reqVo.getBudgetVos().size() ? 1 : 0) != 0, (String)"\u8d39\u7528\u9884\u7b97\u6570\u636e\u53d1\u751f\u53d8\u52a8,\u8bf7\u91cd\u65b0\u9009\u62e9\u8d39\u7528\u9884\u7b97");
        HashMap feeBudgetEntityMap = Maps.newHashMap();
        HashSet feeBudgetTypeSet = Sets.newHashSet();
        this.feeBudgetEntities.stream().forEach(o -> {
            feeBudgetEntityMap.put(o.getFeeBudgetCode(), o);
            if (StringUtils.equals((CharSequence)FeeBudgetTypeEnum.DEPARTMENT.getCode(), (CharSequence)o.getFeeBudgetType())) {
                feeBudgetTypeSet.add(o.getFeeBudgetType() + o.getOrgType());
            } else {
                feeBudgetTypeSet.add(o.getFeeBudgetType());
            }
        });
        this.feeBudgetEntityMap = feeBudgetEntityMap;
        HashMap reduceOrderMap = Maps.newHashMap();
        HashSet reduceOrderSet = Sets.newHashSet();
        HashMap reduceRatioMap = Maps.newHashMap();
        HashSet reduceRatioSet = Sets.newHashSet();
        this.reqVo.getBudgetVos().forEach(o -> {
            AssertUtils.isNotNull((Object)o.getReduceOrder(), (String)"\u6263\u51cf\u987a\u5e8f\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isNotNull((Object)o.getReduceRatio(), (String)"\u6263\u51cf\u6bd4\u4f8b\u4e0d\u80fd\u4e3a\u7a7a");
            reduceOrderSet.add(o.getReduceOrder());
            reduceRatioSet.add(o.getReduceRatio());
            TpmFeeBudgetEntity feeBudgetEntity = (TpmFeeBudgetEntity)((Object)((Object)feeBudgetEntityMap.get(o.getFeeBudgetCode())));
            AssertUtils.isNotNull((Object)((Object)feeBudgetEntity), (String)("\u8d39\u7528\u9884\u7b97:" + o.getFeeBudgetCode() + ",\u4e0d\u5b58\u5728"));
            AssertUtils.isTrue((boolean)StringUtils.equals((CharSequence)CrmEnableStatusEnum.ENABLE.getCode(), (CharSequence)feeBudgetEntity.getEnableStatus()), (String)("\u8d39\u7528\u9884\u7b97:" + o.getFeeBudgetCode() + ",\u5df2\u7ecf\u88ab\u7981\u7528"));
            String mapKey = StringUtils.equals((CharSequence)FeeBudgetTypeEnum.DEPARTMENT.getCode(), (CharSequence)o.getFeeBudgetType()) ? feeBudgetEntity.getFeeBudgetType() + feeBudgetEntity.getOrgType() : feeBudgetEntity.getFeeBudgetType();
            Integer integer = (Integer)reduceOrderMap.get(mapKey);
            if (Objects.isNull(integer)) {
                reduceOrderMap.put(mapKey, o.getReduceOrder());
            } else {
                AssertUtils.isTrue((boolean)Objects.equals(integer, o.getReduceOrder()), (String)"\u76f8\u540c\u8d39\u7528\u9884\u7b97\u7c7b\u578b\u7684\u6570\u636e\u6263\u51cf\u987a\u5e8f\u5fc5\u987b\u4e00\u81f4");
            }
            BigDecimal bigDecimal = (BigDecimal)reduceRatioMap.get(mapKey);
            if (Objects.isNull(bigDecimal)) {
                reduceRatioMap.put(mapKey, o.getReduceRatio());
            } else {
                AssertUtils.isTrue((boolean)Objects.equals(bigDecimal, o.getReduceRatio()), (String)"\u76f8\u540c\u8d39\u7528\u9884\u7b97\u7c7b\u578b\u7684\u6570\u636e\u6263\u51cf\u6bd4\u4f8b\u5fc5\u987b\u4e00\u81f4");
            }
        });
        Integer max = reduceOrderSet.stream().map(o -> o).reduce(Integer::max).get();
        Integer min = reduceOrderSet.stream().map(o -> o).reduce(Integer::min).get();
        AssertUtils.isTrue((boolean)Objects.equals(max, reduceOrderSet.size()), (String)"\u6263\u51cf\u987a\u5e8f\u6700\u5927\u503c\u9519\u8bef");
        AssertUtils.isTrue((boolean)Objects.equals(min, 1), (String)"\u6263\u51cf\u987a\u5e8f\u6700\u5c0f\u503c\u5fc5\u987b\u4e3a1");
        BigDecimal bigDecimal = reduceRatioSet.stream().map(o -> o).reduce(BigDecimal::add).get();
        AssertUtils.isTrue((bigDecimal.compareTo(BigDecimal.valueOf(100L)) == 0 ? 1 : 0) != 0, (String)"\u6263\u51cf\u6bd4\u4f8b\u548c\u5fc5\u987b\u7b49\u4e8e100");
    }

    public void checkDetailData() {
        AssertUtils.isNotNull((Object)this.reqVo.getDetailVos(), (String)"\u660e\u7ec6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        Map categoriesEntitiesMap = this.categoriesEntities.stream().collect(Collectors.toMap(TpmCostTypeCategoriesEntity::getCategoriesCode, Function.identity()));
        this.categoriesEntitiesMap = categoriesEntitiesMap;
        this.reqVo.getDetailVos().forEach(o -> {
            AssertUtils.isNotEmpty((String)o.getCategoriesCode(), (String)"\u6d3b\u52a8\u5927\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)o.getFineCode(), (String)"\u6d3b\u52a8\u7ec6\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)o.getPayType(), (String)"\u652f\u4ed8\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isNotNull((Object)o.getApplyAmount(), (String)"\u8d39\u7528\u7533\u8bf7\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
            this.reqVo.setTotalAmount(Optional.ofNullable(this.reqVo.getTotalAmount()).orElse(BigDecimal.ZERO).add(o.getApplyAmount()));
        });
    }

    public void checkShareData() {
        List feeShareVos = this.reqVo.getFeeShareVos();
        AssertUtils.isNotEmpty((Collection)feeShareVos, (String)"\u8d39\u7528\u5206\u644a\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList feeShareList = Lists.newArrayList();
        ArrayList productShareList = Lists.newArrayList();
        feeShareVos.forEach(o -> {
            AssertUtils.isNotEmpty((String)o.getShareType(), (String)"\u8d39\u7528\u5206\u644a\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            if (StringUtils.equals((CharSequence)ActFeeShareTypeEnum.FEE.getCode(), (CharSequence)o.getShareType())) {
                AssertUtils.isNotEmpty((String)o.getFeeDateStr(), (String)"\u8d39\u7528\u6240\u5c5e\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a");
                feeShareList.add(o);
            }
            if (StringUtils.equals((CharSequence)ActFeeShareTypeEnum.PRODUCT.getCode(), (CharSequence)o.getShareType())) {
                AssertUtils.isNotEmpty((String)o.getProductAndLevelCode(), (String)"\u4ea7\u54c1/\u4ea7\u54c1\u5c42\u7ea7\u4e0d\u80fd\u4e3a\u7a7a");
                AssertUtils.isNotEmpty((String)o.getProductShareType(), (String)"\u4ea7\u54c1\u5206\u644a\u7c7b\u578b(\u4ea7\u54c1,\u4ea7\u54c1\u5c42\u7ea7)\u4e0d\u80fd\u4e3a\u7a7a");
                productShareList.add(o);
            }
            AssertUtils.isNotNull((Object)o.getShareRatio(), (String)"\u5206\u644a\u6bd4\u4f8b\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isNotNull((Object)o.getShareAmount(), (String)"\u5206\u644a\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
            o.setShareAmount(this.reqVo.getTotalAmount().multiply(o.getShareRatio()).divide(BigDecimal.valueOf(100L)));
        });
        this.checkFeeShareRatioAndAmount(productShareList);
        this.checkFeeShareRatioAndAmount(feeShareList);
    }

    public void checkFeeShareRatioAndAmount(List<TmpActFeeShareReqVo> list) {
        BigDecimal totalRatio = list.stream().map(TmpActFeeShareReqVo::getShareRatio).reduce(BigDecimal::add).get();
        AssertUtils.isTrue((totalRatio.compareTo(BigDecimal.valueOf(100L)) == 0 ? 1 : 0) != 0, (String)"\u5206\u644a\u6bd4\u4f8b\u603b\u548c\u5fc5\u987b\u7b49\u4e8e100");
        list.forEach(o -> AssertUtils.isNotNull((Object)o.getShareAmount(), (String)"\u5206\u644a\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a"));
    }

    public ActBuilder convert() {
        CrmBeanUtil.copyProperties((Object)this.reqVo, (Object)((Object)this.actEntity));
        if (StringUtils.isEmpty((CharSequence)this.actEntity.getActCode())) {
            String actCode = CodeUtil.createOneCode((String)"tpm_act");
            this.actEntity.setActCode(actCode);
        }
        this.reqVo.getBudgetVos().stream().forEach(o -> {
            TpmActBudgetEntity actBudgetEntity = new TpmActBudgetEntity();
            CrmBeanUtil.copyProperties((Object)o, (Object)((Object)actBudgetEntity));
            actBudgetEntity.setActCode(this.actEntity.getActCode());
            this.actBudgetEntities.add(actBudgetEntity);
        });
        this.reqVo.getDetailVos().forEach(o -> {
            TpmActDetailEntity actDetailEntity = new TpmActDetailEntity();
            CrmBeanUtil.copyProperties((Object)o, (Object)((Object)actDetailEntity));
            if (StringUtils.isEmpty((CharSequence)o.getActDetailCode())) {
                actDetailEntity.setActDetailCode(CodeUtil.createOneCode((String)"tpm_act_detail"));
            }
            actDetailEntity.setActCode(this.actEntity.getActCode());
            this.actDetailEntities.add(actDetailEntity);
        });
        this.reqVo.getFeeShareVos().forEach(o -> {
            TmpActFeeShareEntity actFeeShareEntity = new TmpActFeeShareEntity();
            CrmBeanUtil.copyProperties((Object)o, (Object)((Object)actFeeShareEntity));
            actFeeShareEntity.setActCode(this.actEntity.getActCode());
            this.shareEntities.add(actFeeShareEntity);
        });
        if (CollectionUtils.isNotEmpty((Collection)this.reqVo.getFileList())) {
            this.reqVo.getFileList().forEach(o -> {
                TpmActFileEntity fileEntity = new TpmActFileEntity();
                CrmBeanUtil.copyProperties((Object)o, (Object)((Object)fileEntity));
                fileEntity.setActCode(this.actEntity.getActCode());
                this.fileEntities.add(fileEntity);
            });
        }
        return this;
    }

    public void convertFeeBudgetDetailsEntities() {
        String currentMonth = String.valueOf(DateUtil.getCurrentMonth());
        String currentYear = String.valueOf(DateUtil.getCurrentYear());
        this.actDetailEntities.stream().forEach(o -> {
            TpmFeeBudgetDetailsEntity entity = new TpmFeeBudgetDetailsEntity();
            entity.setMonth(currentMonth);
            entity.setYear(currentYear);
            entity.setBusinessCode(this.actEntity.getActCode());
            entity.setBusinessLineCode(o.getActDetailCode());
            this.feeBudgetDetailsEntities.add(entity);
        });
    }

    public void save() {
        this.helper.saveOrUpdateAct(this.actEntity);
        this.helper.saveActBudgets(this.actBudgetEntities);
        this.helper.saveActDetails(this.actDetailEntities);
        this.helper.saveActShares(this.shareEntities);
        this.helper.saveActFiles(this.fileEntities);
        this.helper.saveFeeBudgetDetails(this.feeBudgetDetailsEntities, this.reqVo);
    }

    public void update() {
    }
}

