/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.act.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.act.mapper.TpmActBudgetMapper;
import com.biz.crm.act.mapper.TpmActDetailMapper;
import com.biz.crm.act.mapper.TpmActFeeShareMapper;
import com.biz.crm.act.mapper.TpmActFileMapper;
import com.biz.crm.act.mapper.TpmActMapper;
import com.biz.crm.act.model.TmpActFeeShareEntity;
import com.biz.crm.act.model.TpmActBudgetEntity;
import com.biz.crm.act.model.TpmActDetailEntity;
import com.biz.crm.act.model.TpmActEntity;
import com.biz.crm.act.model.TpmActFileEntity;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BaseServiceHelper;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.costtypecategories.mapper.TpmCostTypeCategoriesFineMapper;
import com.biz.crm.costtypecategories.mapper.TpmCostTypeCategoriesMapper;
import com.biz.crm.costtypecategories.model.TpmCostTypeCategoriesEntity;
import com.biz.crm.costtypecategories.model.TpmCostTypeCategoriesFineEntity;
import com.biz.crm.costtypefine.mapper.TpmCostTypeFineMapper;
import com.biz.crm.costtypefine.model.TpmCostTypeFineEntity;
import com.biz.crm.eunm.GlobalWhetherEnum;
import com.biz.crm.eunm.tpm.ActApproveStatusEnum;
import com.biz.crm.eunm.tpm.FeeBudgetDetailTypeEnum;
import com.biz.crm.feebudget.mapper.TpmFeeBudgetDetailsMapper;
import com.biz.crm.feebudget.mapper.TpmFeeBudgetMapper;
import com.biz.crm.feebudget.model.TpmFeeBudgetDetailsEntity;
import com.biz.crm.feebudget.model.TpmFeeBudgetEntity;
import com.biz.crm.feebudget.service.ITpmFeeBudgetDetailsService;
import com.biz.crm.feebudget.service.ITpmFeeBudgetService;
import com.biz.crm.nebular.tpm.act.req.TpmActReqVo;
import com.biz.crm.nebular.tpm.act.resp.TpmActRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.DictUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActServiceHelper
extends BaseServiceHelper {
    private static final Logger log = LoggerFactory.getLogger(ActServiceHelper.class);
    @Resource
    private TpmActMapper actMapper;
    @Resource
    private TpmActBudgetMapper tpmActBudgetMapper;
    @Resource
    private TpmActDetailMapper actDetailMapper;
    @Resource
    private TpmActFeeShareMapper actFeeShareMapper;
    @Resource
    private TpmActFileMapper actFileMapper;
    @Resource
    private TpmFeeBudgetDetailsMapper feeBudgetDetailsMapper;
    @Resource
    private TpmFeeBudgetMapper feeBudgetMapper;
    @Autowired
    private ITpmFeeBudgetService feeBudgetService;
    @Autowired
    private ITpmFeeBudgetDetailsService feeBudgetDetailsService;
    @Resource
    private TpmCostTypeCategoriesMapper categoriesMapper;
    @Resource
    private TpmCostTypeFineMapper fineMapper;
    @Resource
    private TpmCostTypeCategoriesFineMapper categoriesFineMapper;

    public Map<String, Map<String, String>> getDicts() {
        ArrayList dictCodes = Lists.newArrayList();
        dictCodes.add("enable_status");
        dictCodes.add("act_type");
        dictCodes.add("act_approve_status");
        return DictUtil.getDictValueMapsByCodes((List)dictCodes);
    }

    public void convertListDate(List<TpmActRespVo> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            Map<String, Map<String, String>> map = this.getDicts();
            list.forEach(o -> {
                if (StringUtils.isNotEmpty((CharSequence)o.getEnableStatus())) {
                    o.setEnableStatusName((String)((Map)Optional.ofNullable(map.get("enable_status")).orElse(Maps.newHashMap())).get(o.getEnableStatus()));
                }
                if (StringUtils.isNotEmpty((CharSequence)o.getActType())) {
                    o.setActTypeName((String)((Map)Optional.ofNullable(map.get("act_type")).orElse(Maps.newHashMap())).get(o.getActType()));
                }
                if (StringUtils.isNotEmpty((CharSequence)o.getApproveStatus())) {
                    o.setApproveStatusName((String)((Map)Optional.ofNullable(map.get("act_approve_status")).orElse(Maps.newHashMap())).get(o.getApproveStatus()));
                }
            });
        }
    }

    public LambdaQueryWrapper<TpmActEntity> getQueryWrapper(TpmActReqVo reqVo) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(StringUtils.isNotEmpty((CharSequence)reqVo.getEnableStatus()), CrmBaseEntity::getEnableStatus, (Object)reqVo.getEnableStatus());
        return wrapper;
    }

    public void updateBySelectAll(TpmActReqVo reqVo, TpmActEntity entity) {
        LambdaQueryWrapper<TpmActEntity> queryWrapper = this.getQueryWrapper(reqVo);
        this.actMapper.update((Object)entity, (Wrapper)queryWrapper);
    }

    public void saveCheck(TpmActReqVo reqVo) {
        this.checkDataExist(reqVo);
    }

    public void checkDataExist(TpmActReqVo reqVo) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
    }

    public void deleteCheck(TpmActReqVo reqVo) {
        reqVo.setPageSize(Integer.valueOf(-1));
        List<TpmActRespVo> list = this.actMapper.findList((Page<TpmActRespVo>)new Page(1L, -1L), reqVo);
        AssertUtils.isNotNull(list, (String)"\u8bf7\u9009\u62e9\u60a8\u9700\u8981\u5220\u9664\u7684\u6570\u636e");
        StringBuffer errorMsg = new StringBuffer();
        errorMsg.append("\u6d3b\u52a8\u7f16\u7801:[");
        if (CollectionUtils.isNotEmpty(list)) {
            StringBuffer msg = new StringBuffer();
            list.forEach(o -> {
                if (!StringUtils.equals((CharSequence)ActApproveStatusEnum.CREATE.getCode(), (CharSequence)o.getApproveStatus())) {
                    msg.append(o.getActCode()).append(",");
                }
            });
            if (StringUtils.isNotEmpty((CharSequence)msg.toString())) {
                throw new BusinessException(errorMsg.append(msg.toString()).append("],\u7684\u6d3b\u52a8\u72b6\u6001\u4e0d\u4e3a\u5f85\u63d0\u4ea4,\u4e0d\u80fd\u5220\u9664").toString());
            }
        }
    }

    public List<TpmActRespVo> closedCheck(TpmActReqVo reqVo) {
        reqVo.setPageSize(Integer.valueOf(-1));
        List<TpmActRespVo> list = this.actMapper.findList((Page<TpmActRespVo>)new Page(1L, -1L), reqVo);
        AssertUtils.isNotNull(list, (String)"\u8bf7\u9009\u62e9\u60a8\u9700\u8981\u5173\u95ed\u7684\u6570\u636e");
        StringBuffer errorMsg2 = new StringBuffer();
        StringBuffer errorMsg1 = new StringBuffer();
        errorMsg2.append("\u6d3b\u52a8\u7f16\u7801:[");
        errorMsg1.append("\u6d3b\u52a8\u7f16\u7801:[");
        if (CollectionUtils.isNotEmpty(list)) {
            StringBuffer msg = new StringBuffer();
            StringBuffer msg1 = new StringBuffer();
            list.forEach(o -> {
                if (!StringUtils.equals((CharSequence)ActApproveStatusEnum.APPROVED.getCode(), (CharSequence)o.getApproveStatus())) {
                    msg.append(o.getActCode()).append(",");
                }
                if (StringUtils.equals((CharSequence)GlobalWhetherEnum.YES.getCode(), (CharSequence)o.getIsAllAudit())) {
                    msg1.append(o.getActCode()).append(",");
                }
            });
            if (StringUtils.isNotEmpty((CharSequence)msg.toString())) {
                throw new BusinessException(errorMsg2.append(msg.toString()).append("],\u7684\u6d3b\u52a8\u72b6\u6001\u4e0d\u4e3a\u5ba1\u6279\u901a\u8fc7,\u4e0d\u80fd\u5173\u95ed").toString());
            }
            if (StringUtils.isNotEmpty((CharSequence)msg1.toString())) {
                throw new BusinessException(errorMsg1.append(msg1.toString()).append("],\u7684\u6d3b\u52a8\u5df2\u5b8c\u5168\u6838\u9500\uff0c\u65e0\u9700\u5173\u95ed\u201d").toString());
            }
        }
        return list;
    }

    public void closedBatch(List<TpmActRespVo> list) {
        List<String> actCodes = list.stream().map(TpmActRespVo::getActCode).collect(Collectors.toList());
        List detailEntities = this.actDetailMapper.selectList((Wrapper)new LambdaQueryWrapper().in(TpmActDetailEntity::getActCode, actCodes));
        Map<String, List<TpmActDetailEntity>> actDetailMap = detailEntities.stream().collect(Collectors.groupingBy(TpmActDetailEntity::getActCode));
        List actDetailCodes = detailEntities.stream().map(TpmActDetailEntity::getActDetailCode).collect(Collectors.toList());
        List budgetDetailsEntities = this.feeBudgetDetailsMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(TpmFeeBudgetDetailsEntity::getBusinessCode, actCodes)).in(TpmFeeBudgetDetailsEntity::getBusinessLineCode, actDetailCodes)).eq(TpmFeeBudgetDetailsEntity::getFeeBudgetDetailType, (Object)FeeBudgetDetailTypeEnum.USE.getCode()));
        Map budgetDetailsMap = budgetDetailsEntities.stream().collect(Collectors.toMap(o -> o.getBusinessCode() + o.getBusinessLineCode(), Function.identity()));
        Set<String> feeBudgetCodes = budgetDetailsEntities.stream().map(TpmFeeBudgetDetailsEntity::getFeeBudgetCode).collect(Collectors.toSet());
        List<TpmFeeBudgetEntity> feeBudgetEntities = this.findFeeBudgetByCodes(feeBudgetCodes);
        Map feeBudgetMap = feeBudgetEntities.stream().collect(Collectors.toMap(TpmFeeBudgetEntity::getFeeBudgetCode, Function.identity()));
        String year = String.valueOf(DateUtil.getCurrentYear());
        String month = String.valueOf(DateUtil.getCurrentMonth());
        ArrayList saveFeeBudgetDetails = Lists.newArrayList();
        for (TpmActRespVo o2 : list) {
            List<TpmActDetailEntity> tpmActDetailEntities = actDetailMap.get(o2.getActCode());
            for (TpmActDetailEntity p : tpmActDetailEntities) {
                if (!StringUtils.equals((CharSequence)GlobalWhetherEnum.NO.getCode(), (CharSequence)p.getIsAllAudit())) continue;
                TpmFeeBudgetDetailsEntity budgetDetailsEntity = (TpmFeeBudgetDetailsEntity)((Object)budgetDetailsMap.get(p.getActCode() + p.getActDetailCode()));
                TpmFeeBudgetEntity budgetEntity = (TpmFeeBudgetEntity)((Object)feeBudgetMap.get(budgetDetailsEntity.getFeeBudgetCode()));
                BigDecimal decimal = p.getApplyAmount().subtract(p.getAuditAmount());
                budgetEntity.setCanUseAmount(budgetEntity.getCanUseAmount().add(decimal));
                budgetEntity.setUsedAmount(budgetEntity.getUsedAmount().subtract(decimal));
                TpmFeeBudgetDetailsEntity newBudgetDetailsEntity = new TpmFeeBudgetDetailsEntity();
                CrmBeanUtil.copyProperties((Object)((Object)budgetDetailsEntity), (Object)((Object)newBudgetDetailsEntity));
                newBudgetDetailsEntity.setFeeAmount(decimal);
                newBudgetDetailsEntity.setAfterAmount(budgetEntity.getCanUseAmount());
                newBudgetDetailsEntity.setBeforAmount(budgetEntity.getCanUseAmount().subtract(decimal));
                newBudgetDetailsEntity.setYear(year);
                newBudgetDetailsEntity.setMonth(month);
                super.setPublicParamsNull((CrmBaseEntity)newBudgetDetailsEntity);
                saveFeeBudgetDetails.add(newBudgetDetailsEntity);
            }
        }
        this.actMapper.updateApprovedStatusByCodes(actCodes, ActApproveStatusEnum.CLOSED.getCode());
        this.feeBudgetService.updateBatchById(feeBudgetEntities);
        this.feeBudgetDetailsService.saveBatch(saveFeeBudgetDetails);
    }

    public List<TpmFeeBudgetEntity> findFeeBudgetByCodes(Collection<String> feeBudgetCodes) {
        List feeBudgetEntities = this.feeBudgetMapper.selectList((Wrapper)new LambdaQueryWrapper().in(TpmFeeBudgetEntity::getFeeBudgetCode, feeBudgetCodes));
        return feeBudgetEntities;
    }

    public TpmActEntity approveCheck(TpmActReqVo tpmActReqVo) {
        AssertUtils.isNotEmpty((String)tpmActReqVo.getProcessCode(), (String)"\u8bf7\u9009\u62e9\u6d41\u7a0b");
        AssertUtils.isNotEmpty((String)tpmActReqVo.getId(), (String)"\u8bf7\u9009\u62e9\u60a8\u9700\u8981\u5173\u95ed\u7684\u6570\u636e");
        TpmActEntity tpmActEntity = (TpmActEntity)((Object)this.actMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(BaseIdEntity::getId, (Object)tpmActReqVo.getId())));
        Set canApproveStatus = ActApproveStatusEnum.getCanApproveStatus();
        AssertUtils.isTrue((boolean)canApproveStatus.contains(tpmActEntity.getApproveStatus()), (String)"\u4ec5\u72b6\u6001\u4e3a\u201c\u5f85\u63d0\u4ea4\u3001\u5ba1\u6279\u9a73\u56de\u3001\u6d41\u7a0b\u8ffd\u56de\u201d\u7684\u5355\u636e\u53ef\u63d0\u4ea4\u5ba1\u6279");
        return tpmActEntity;
    }

    public List<TpmCostTypeCategoriesEntity> findCategoriesEntitiesByCodes(Collection<String> categoriesCodes) {
        List tpmCostTypeCategoriesEntities = this.categoriesMapper.selectList((Wrapper)new LambdaQueryWrapper().in(CrmBaseEntity::getCreateOrgCode, categoriesCodes));
        return tpmCostTypeCategoriesEntities;
    }

    public List<TpmCostTypeFineEntity> findFineEntitiesByCodes(Collection<String> fineCodes) {
        List tpmCostTypeFineEntities = this.fineMapper.selectList((Wrapper)new LambdaQueryWrapper().in(TpmCostTypeFineEntity::getFineCode, fineCodes));
        return tpmCostTypeFineEntities;
    }

    public List<TpmCostTypeCategoriesFineEntity> findCategoriesFineEntities(Collection<String> categoriesCodes, Collection<String> fineCodes) {
        List tpmCostTypeCategoriesFineEntities = this.categoriesFineMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(TpmCostTypeCategoriesFineEntity::getCategoriesCode, categoriesCodes)).in(TpmCostTypeCategoriesFineEntity::getFineCode, fineCodes));
        return tpmCostTypeCategoriesFineEntities;
    }

    public void saveOrUpdateAct(TpmActEntity actEntity) {
        if (StringUtils.isNotEmpty((CharSequence)actEntity.getId())) {
            this.actMapper.updateById((Object)actEntity);
        } else {
            this.actMapper.insert((Object)actEntity);
        }
    }

    public void saveActBudgets(List<TpmActBudgetEntity> actBudgetEntities) {
        actBudgetEntities.forEach(o -> this.tpmActBudgetMapper.insert(o));
    }

    public void saveActDetails(List<TpmActDetailEntity> actDetailEntities) {
        actDetailEntities.forEach(o -> this.actDetailMapper.insert(o));
    }

    public void saveActShares(List<TmpActFeeShareEntity> shareEntities) {
        shareEntities.stream().forEach(o -> this.actFeeShareMapper.insert(o));
    }

    public void saveActFiles(List<TpmActFileEntity> fileEntities) {
        fileEntities.forEach(o -> this.actFileMapper.insert(o));
    }

    public void saveFeeBudgetDetails(List<TpmFeeBudgetDetailsEntity> feeBudgetDetailsEntities, TpmActReqVo reqVo) {
        Map<String, List<TpmFeeBudgetDetailsEntity>> map = feeBudgetDetailsEntities.stream().collect(Collectors.groupingBy(TpmFeeBudgetDetailsEntity::getFeeBudgetCode));
    }
}

