/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.act.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.act.mapper.TpmActBudgetMapper;
import com.biz.crm.act.model.TpmActBudgetEntity;
import com.biz.crm.act.service.ITpmActBudgetService;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.tpm.act.req.TpmActBudgetReqVo;
import com.biz.crm.nebular.tpm.act.resp.TpmActBudgetRespVo;
import com.biz.crm.util.CrmBeanUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"TpmActBudgetServiceExpandImpl"})
public class TpmActBudgetServiceImpl
extends ServiceImpl<TpmActBudgetMapper, TpmActBudgetEntity>
implements ITpmActBudgetService {
    private static final Logger log = LoggerFactory.getLogger(TpmActBudgetServiceImpl.class);
    @Resource
    private TpmActBudgetMapper tpmActBudgetMapper;

    @Override
    public PageResult<TpmActBudgetRespVo> findList(TpmActBudgetReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<TpmActBudgetRespVo> list = this.tpmActBudgetMapper.findList((Page<TpmActBudgetRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public TpmActBudgetRespVo query(TpmActBudgetReqVo reqVo) {
        List tpmActBudgetEntities = this.tpmActBudgetMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(TpmActBudgetEntity::getActCode, (Object)reqVo.getActCode()));
        if (CollectionUtils.isEmpty((Collection)tpmActBudgetEntities)) {
            return null;
        }
        TpmActBudgetRespVo tpmActBudgetRespVos = (TpmActBudgetRespVo)CrmBeanUtil.copy(tpmActBudgetEntities.get(0), TpmActBudgetRespVo.class);
        return tpmActBudgetRespVos;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(TpmActBudgetReqVo reqVo) {
        TpmActBudgetEntity entity = (TpmActBudgetEntity)((Object)CrmBeanUtil.copy((Object)reqVo, TpmActBudgetEntity.class));
        this.save((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(TpmActBudgetReqVo reqVo) {
        TpmActBudgetEntity entity = (TpmActBudgetEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        this.updateById((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(TpmActBudgetReqVo reqVo) {
        List tpmActBudgetEntities = this.tpmActBudgetMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)tpmActBudgetEntities)) {
            tpmActBudgetEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
        }
        this.updateBatchById(tpmActBudgetEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(TpmActBudgetReqVo reqVo) {
        List tpmActBudgetEntities = this.tpmActBudgetMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)tpmActBudgetEntities)) {
            tpmActBudgetEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(tpmActBudgetEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(TpmActBudgetReqVo reqVo) {
        List tpmActBudgetEntities = this.tpmActBudgetMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)tpmActBudgetEntities)) {
            tpmActBudgetEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(tpmActBudgetEntities);
    }
}

