/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.act.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.act.mapper.TpmActBudgetMapper;
import com.biz.crm.act.mapper.TpmActDetailMapper;
import com.biz.crm.act.mapper.TpmActFeeShareMapper;
import com.biz.crm.act.mapper.TpmActFileMapper;
import com.biz.crm.act.mapper.TpmActMapper;
import com.biz.crm.act.model.TpmActBudgetEntity;
import com.biz.crm.act.model.TpmActEntity;
import com.biz.crm.act.model.TpmActFileEntity;
import com.biz.crm.act.service.ITpmActFileService;
import com.biz.crm.act.service.ITpmActService;
import com.biz.crm.act.service.impl.ActBuilder;
import com.biz.crm.act.service.impl.ActServiceHelper;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.DictItemVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.SelectAllFlagEnum;
import com.biz.crm.eunm.tpm.ActApproveStatusEnum;
import com.biz.crm.exception.CommonException;
import com.biz.crm.exception.CrmExceptionType;
import com.biz.crm.feebudget.mapper.TpmFeeBudgetControlMapper;
import com.biz.crm.feebudget.model.TpmFeeBudgetControlEntity;
import com.biz.crm.feebudget.service.ITpmFeeBudgetControlService;
import com.biz.crm.mdm.customer.MdmCustomerMsgFeign;
import com.biz.crm.mdm.humanarea.EngineOrgFeign;
import com.biz.crm.mdm.material.MdmMaterialFeign;
import com.biz.crm.mdm.terminal.MdmTerminalFeign;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.humanarea.EngineOrgRespVo;
import com.biz.crm.nebular.mdm.humanarea.EngineOrgSearchReqVo;
import com.biz.crm.nebular.mdm.humanarea.MdmCustomerOrgSearchReqVo;
import com.biz.crm.nebular.mdm.humanarea.MdmMaterialOrgSearchReqVo;
import com.biz.crm.nebular.mdm.humanarea.MdmTerminalOrgSearchReqVo;
import com.biz.crm.nebular.mdm.material.MdmMaterialPriceRespVo;
import com.biz.crm.nebular.mdm.terminal.req.MdmTerminalReqVo;
import com.biz.crm.nebular.mdm.terminal.resp.MdmTerminalRespVo;
import com.biz.crm.nebular.tpm.act.req.ActGetCustomerCodeByOrgCodeReqVo;
import com.biz.crm.nebular.tpm.act.req.ActGetOrgInfoReqVo;
import com.biz.crm.nebular.tpm.act.req.ActGetTerminalByCustomerCodeReqVo;
import com.biz.crm.nebular.tpm.act.req.TpmActDetailReqVo;
import com.biz.crm.nebular.tpm.act.req.TpmActFileReqVo;
import com.biz.crm.nebular.tpm.act.req.TpmActReqVo;
import com.biz.crm.nebular.tpm.act.resp.TpmActDetailRespVo;
import com.biz.crm.nebular.tpm.act.resp.TpmActFileRespVo;
import com.biz.crm.nebular.tpm.act.resp.TpmActRespVo;
import com.biz.crm.nebular.tpm.costtypefine.resp.TpmCostTypeFineRespVo;
import com.biz.crm.nebular.tpm.feebudget.req.TpmFeeBudgetControlReqVo;
import com.biz.crm.nebular.tpm.feebudget.resp.TpmFeeBudgetControlRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"TpmActServiceExpandImpl"})
public class TpmActServiceImpl
extends ServiceImpl<TpmActMapper, TpmActEntity>
implements ITpmActService {
    private static final Logger log = LoggerFactory.getLogger(TpmActServiceImpl.class);
    @Resource
    private TpmActMapper tpmActMapper;
    @Resource
    private ActServiceHelper serviceHelper;
    @Resource
    private ITpmActFileService actFileService;
    @Resource
    private TpmFeeBudgetControlMapper tpmFeeBudgetControlMapper;
    @Resource
    private EngineOrgFeign engineOrgFeign;
    @Resource
    private MdmCustomerMsgFeign mdmCustomerMsgFeign;
    @Resource
    private MdmTerminalFeign mdmTerminalFeign;
    @Resource
    private MdmMaterialFeign mdmMaterialFeign;
    @Resource
    private TpmActBudgetMapper budgetMapper;
    @Resource
    private TpmActDetailMapper detailMapper;
    @Resource
    private TpmActFeeShareMapper feeShareMapper;
    @Resource
    private TpmActFileMapper fileMapper;
    @Autowired
    private ITpmFeeBudgetControlService budgetControlService;

    @Override
    public PageResult<TpmActRespVo> findList(TpmActReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<TpmActRespVo> list = this.tpmActMapper.findList((Page<TpmActRespVo>)page, reqVo);
        this.serviceHelper.convertListDate(list);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public TpmActRespVo query(TpmActReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        PageResult<TpmActRespVo> data = this.findList(reqVo);
        List list = data.getData();
        AssertUtils.isNotEmpty((Collection)list, (String)"\u60a8\u9009\u62e9\u7684\u6570\u636e\u4e0d\u5b58\u5728");
        TpmActRespVo respVo = (TpmActRespVo)list.get(0);
        List budgetEntities = this.budgetMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(TpmActBudgetEntity::getActCode, (Object)respVo.getActCode()));
        if (CollectionUtils.isNotEmpty((Collection)budgetEntities)) {
            HashSet controlIds = Sets.newHashSet();
            HashMap map = Maps.newHashMap();
            budgetEntities.forEach(o -> {
                map.put(o.getFeeBudgetCode(), o);
                controlIds.add(o.getControlId());
            });
            TpmFeeBudgetControlReqVo controlReqVo = new TpmFeeBudgetControlReqVo();
            controlReqVo.setIds((Collection)controlIds);
            List<TpmFeeBudgetControlRespVo> budgetControlRespVos = this.budgetControlService.list(controlReqVo);
            if (CollectionUtils.isNotEmpty(budgetControlRespVos)) {
                budgetControlRespVos.forEach(o -> {
                    List feeBudgetVos = o.getFeeBudgetVos();
                    if (CollectionUtils.isNotEmpty((Collection)feeBudgetVos)) {
                        feeBudgetVos.forEach(p -> {
                            TpmActBudgetEntity budgetEntity = (TpmActBudgetEntity)((Object)((Object)((Object)map.get(p.getFeeBudgetCode()))));
                            p.setReduceRatio(budgetEntity.getReduceRatio());
                            p.setReduceOrder(budgetEntity.getReduceOrder());
                            p.setActCode(budgetEntity.getActCode());
                        });
                    }
                });
            }
            respVo.setEditBudgetVos(budgetControlRespVos);
        }
        TpmActDetailReqVo detailReqVo = new TpmActDetailReqVo();
        detailReqVo.setActCode(respVo.getActCode());
        Page page = new Page((long)reqVo.getPageNum().intValue(), -1L);
        List<TpmActDetailRespVo> detailRespVos = this.detailMapper.findList((Page<TpmActDetailRespVo>)page, detailReqVo);
        respVo.setDetailVos(detailRespVos);
        TpmActFileReqVo fileReqVo = new TpmActFileReqVo();
        fileReqVo.setActCode(respVo.getActCode());
        Page filePage = new Page((long)reqVo.getPageNum().intValue(), -1L);
        List<TpmActFileRespVo> fileRespVos = this.fileMapper.findList((Page<TpmActFileRespVo>)filePage, fileReqVo);
        respVo.setFileList(fileRespVos);
        return respVo;
    }

    @Override
    public List<TpmCostTypeFineRespVo> getCategoryFinesByCategoryCode(TpmActDetailReqVo tpmActDetailReqVo) {
        AssertUtils.isNotEmpty((String)tpmActDetailReqVo.getCategoriesCode(), (String)"\u8bf7\u9009\u62e9\u6d3b\u52a8\u5927\u7c7b");
        List<TpmCostTypeFineRespVo> list = this.tpmActMapper.getCategoryFinesByCategoryCode(tpmActDetailReqVo);
        if (CollectionUtils.isNotEmpty(list)) {
            ArrayList dictCodes = Lists.newArrayList();
            dictCodes.add("pay_type_d");
            Map dictValueMapsByCodes = DictUtil.getDictValueMapsByCodes((List)dictCodes);
            Map map = Optional.ofNullable(dictValueMapsByCodes.get("pay_type_d")).orElse(Maps.newHashMap());
            list.forEach(o -> {
                List codes = JSON.parseArray((String)o.getPayTypeList(), String.class);
                ArrayList payTypes = Lists.newArrayList();
                if (CollectionUtils.isNotEmpty((Collection)codes)) {
                    codes.forEach(p -> {
                        String s = (String)map.get(p);
                        DictItemVo dictItemVo = new DictItemVo();
                        dictItemVo.setDictKey(s);
                        dictItemVo.setDictValue(p);
                        payTypes.add(dictItemVo);
                    });
                }
                o.setPayTypes((List)payTypes);
            });
        }
        return list;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(TpmActReqVo reqVo) {
        ActBuilder.builder(this.serviceHelper, reqVo).check().convert().save();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(TpmActReqVo reqVo) {
        ActBuilder.builder(this.serviceHelper, reqVo).check().convert().update();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(TpmActReqVo reqVo) {
        if (!StringUtils.equals((CharSequence)SelectAllFlagEnum.ALL.getCode(), (CharSequence)reqVo.getSelectAllFlag())) {
            AssertUtils.isNotEmpty((Collection)reqVo.getIds(), (CrmExceptionType)CommonException.IDS_NULL);
        }
        this.serviceHelper.deleteCheck(reqVo);
        this.tpmActMapper.deleteByParams(reqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void closed(TpmActReqVo reqVo) {
        if (!StringUtils.equals((CharSequence)SelectAllFlagEnum.ALL.getCode(), (CharSequence)reqVo.getSelectAllFlag())) {
            AssertUtils.isNotEmpty((Collection)reqVo.getIds(), (CrmExceptionType)CommonException.IDS_NULL);
        }
        List<TpmActRespVo> list = this.serviceHelper.closedCheck(reqVo);
        this.serviceHelper.closedBatch(list);
    }

    @Override
    public List<EngineOrgRespVo> getOrgInfoByControlIds(ActGetOrgInfoReqVo tpmActReqVo) {
        AssertUtils.isNotEmpty((Collection)tpmActReqVo.getControlIds(), (String)"\u8bf7\u9009\u62e9\u8d39\u7528\u9884\u7b97");
        Set controlIds = tpmActReqVo.getControlIds().stream().collect(Collectors.toSet());
        List tpmFeeBudgetControlEntities = this.tpmFeeBudgetControlMapper.selectBatchIds(controlIds);
        if (CollectionUtils.isEmpty((Collection)tpmFeeBudgetControlEntities)) {
            return Lists.newArrayList();
        }
        Set orgCodes = tpmFeeBudgetControlEntities.stream().filter(o -> StringUtils.isNotBlank((CharSequence)o.getOrgCode())).map(TpmFeeBudgetControlEntity::getOrgCode).collect(Collectors.toSet());
        UserRedis user = UserUtils.getUser();
        if (Objects.nonNull(user) && Objects.nonNull(user.getOrgcode())) {
            orgCodes.add(user.getOrgcode());
        }
        EngineOrgSearchReqVo engineOrgSearchReqVo = new EngineOrgSearchReqVo();
        engineOrgSearchReqVo.setOrgCodeList((List)Lists.newArrayList(orgCodes));
        engineOrgSearchReqVo.setPageSize(tpmActReqVo.getPageSize());
        engineOrgSearchReqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        engineOrgSearchReqVo.setOrgCodeOrName(tpmActReqVo.getOrgCodeOrName());
        log.info("\u6d3b\u52a8\u65b0\u589e\u6839\u636e\u8d39\u7528\u9884\u7b97\u7f16\u7801\u96c6\u5408\u67e5\u8be2\u7ec4\u7ec7 \u5165\u53c2=\u3010{}\u3011", (Object)JSON.toJSONString((Object)engineOrgSearchReqVo));
        Result currentAndSubOrgCodeList = null;
        try {
            currentAndSubOrgCodeList = this.engineOrgFeign.findCurrentAndSubOrgCodeList(engineOrgSearchReqVo);
        }
        catch (Exception e) {
            log.error("{}", (Throwable)e);
            throw new BusinessException("\u6d3b\u52a8\u65b0\u589e\u6839\u636e\u8d39\u7528\u9884\u7b97\u7f16\u7801\u96c6\u5408\u67e5\u8be2\u7ec4\u7ec7,\u8c03\u7528mdm\u63a5\u53e3\u5931\u8d25");
        }
        log.info("\u6d3b\u52a8\u65b0\u589e\u6839\u636e\u8d39\u7528\u9884\u7b97\u7f16\u7801\u96c6\u5408\u67e5\u8be2\u7ec4\u7ec7 \u8fd4\u56de\u7ed3\u679c=\u3010{}\u3011", (Object)JSON.toJSONString((Object)currentAndSubOrgCodeList));
        return (List)ApiResultUtil.objResult((Result)currentAndSubOrgCodeList, (boolean)true);
    }

    @Override
    public List<MdmCustomerMsgRespVo> getCustomerMsgByOrgCodes(ActGetCustomerCodeByOrgCodeReqVo tpmActReqVo) {
        AssertUtils.isNotEmpty((String)tpmActReqVo.getOrgCode(), (String)"\u8bf7\u9009\u62e9\u7ec4\u7ec7");
        MdmCustomerOrgSearchReqVo mdmCustomerOrgSearchReqVo = new MdmCustomerOrgSearchReqVo();
        mdmCustomerOrgSearchReqVo.setCustomerCodeOrName(tpmActReqVo.getCustomerCodeOrName());
        mdmCustomerOrgSearchReqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        mdmCustomerOrgSearchReqVo.setPageSize(tpmActReqVo.getPageSize());
        mdmCustomerOrgSearchReqVo.setOrgCodeList(Collections.singletonList(tpmActReqVo.getOrgCode()));
        Result currentAndSubCustomerList = null;
        try {
            currentAndSubCustomerList = this.mdmCustomerMsgFeign.findCurrentAndSubCustomerList(mdmCustomerOrgSearchReqVo);
        }
        catch (Exception e) {
            log.error("{}", (Throwable)e);
            throw new BusinessException("\u6d3b\u52a8\u65b0\u589e\u6839\u636e\u7ec4\u7ec7\u83b7\u53d6\u5ba2\u6237\u5217\u8868,\u8c03\u7528mdm\u63a5\u53e3\u5931\u8d25");
        }
        return (List)ApiResultUtil.objResult((Result)currentAndSubCustomerList, (boolean)true);
    }

    @Override
    public List<MdmTerminalRespVo> getTerminalMsgByCustomerCode(ActGetTerminalByCustomerCodeReqVo tpmActReqVo) {
        AssertUtils.isNotEmpty((String)tpmActReqVo.getCustomerCode(), (String)"\u8bf7\u9009\u62e9\u5ba2\u6237");
        MdmTerminalOrgSearchReqVo mdmTerminalOrgSearchReqVo = new MdmTerminalOrgSearchReqVo();
        mdmTerminalOrgSearchReqVo.setPageSize(tpmActReqVo.getPageSize());
        mdmTerminalOrgSearchReqVo.setCustomerCode(tpmActReqVo.getCustomerCode());
        mdmTerminalOrgSearchReqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        mdmTerminalOrgSearchReqVo.setTerminalCodeOrName(tpmActReqVo.getTerminalCodeOrName());
        Result list = null;
        try {
            list = this.mdmTerminalFeign.list(new MdmTerminalReqVo());
        }
        catch (Exception e) {
            log.error("{}", (Throwable)e);
            throw new BusinessException("\u6d3b\u52a8\u65b0\u589e\u6839\u636e\u5ba2\u6237\u83b7\u53d6\u95e8\u5e97\u5217\u8868,\u8c03\u7528mdm\u63a5\u53e3\u5931\u8d25");
        }
        return ((PageResult)list.getResult()).getData();
    }

    @Override
    public List<MdmMaterialPriceRespVo> getMaterialList(ActGetTerminalByCustomerCodeReqVo tpmActReqVo) {
        MdmMaterialOrgSearchReqVo mdmMaterialOrgSearchReqVo = new MdmMaterialOrgSearchReqVo();
        mdmMaterialOrgSearchReqVo.setPageSize(tpmActReqVo.getPageSize());
        mdmMaterialOrgSearchReqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        mdmMaterialOrgSearchReqVo.setMaterialCodeOrName(tpmActReqVo.getMaterialCodeOrName());
        Result currentAndSubMaterialList = null;
        try {
            currentAndSubMaterialList = this.mdmMaterialFeign.findCurrentAndSubMaterialList(mdmMaterialOrgSearchReqVo);
        }
        catch (Exception e) {
            log.error("{}", (Throwable)e);
            throw new BusinessException("\u9886\u7528\u6d3b\u52a8\u65b0\u589e\u9875\u9762\u67e5\u8be2\u7269\u6599\u5217\u8868,\u8c03\u7528mdm\u63a5\u53e3\u5931\u8d25");
        }
        return (List)ApiResultUtil.objResult((Result)currentAndSubMaterialList, (boolean)true);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(TpmActReqVo reqVo) {
        List tpmActEntities = this.tpmActMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)tpmActEntities)) {
            tpmActEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(tpmActEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(TpmActReqVo reqVo) {
        List tpmActEntities = this.tpmActMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)tpmActEntities)) {
            tpmActEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(tpmActEntities);
    }

    @Override
    public void approve(TpmActReqVo tpmActReqVo) {
        TpmActEntity tpmActEntity = this.serviceHelper.approveCheck(tpmActReqVo);
        tpmActEntity.setApproveStatus(ActApproveStatusEnum.APPROVING.getCode());
        this.updateById((Object)tpmActEntity);
        if (CollectionUtils.isNotEmpty((Collection)tpmActReqVo.getFileList())) {
            List fileEntities = tpmActReqVo.getFileList().stream().map(o -> {
                TpmActFileEntity fileEntity = new TpmActFileEntity();
                fileEntity.setActCode(tpmActEntity.getActCode());
                fileEntity.setFileAddress(o.getFileAddress());
                fileEntity.setRemarks("\u63d0\u4ea4\u5ba1\u6279\u6587\u4ef6");
                return fileEntity;
            }).collect(Collectors.toList());
            this.actFileService.saveBatch(fileEntities);
        }
    }
}

