/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.audit.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.act.mapper.TpmActDetailMapper;
import com.biz.crm.act.mapper.TpmActMapper;
import com.biz.crm.act.model.TpmActDetailEntity;
import com.biz.crm.act.model.TpmActEntity;
import com.biz.crm.audit.mapper.TpmAuditMapper;
import com.biz.crm.audit.model.TpmAuditEntity;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.costtypefine.mapper.TpmCostTypeFineMapper;
import com.biz.crm.costtypefine.model.TpmCostTypeFineEntity;
import com.biz.crm.eunm.GlobalWhetherEnum;
import com.biz.crm.eunm.tpm.ActAdvancePayApproveStatusEnum;
import com.biz.crm.eunm.tpm.ActApproveStatusEnum;
import com.biz.crm.exception.CrmExceptionType;
import com.biz.crm.exception.tpm.ActException;
import com.biz.crm.exception.tpm.AuditException;
import com.biz.crm.exception.tpm.CostTypeFineException;
import com.biz.crm.nebular.tpm.audit.req.TpmAuditActReqVo;
import com.biz.crm.nebular.tpm.audit.req.TpmAuditDetailReqVo;
import com.biz.crm.nebular.tpm.audit.req.TpmAuditReqVo;
import com.biz.crm.nebular.tpm.audit.resp.TpmAuditRespVo;
import com.biz.crm.util.AssertUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AuditServiceHelper {
    private static final Logger log = LoggerFactory.getLogger(AuditServiceHelper.class);
    @Resource
    private TpmAuditMapper auditMapper;
    @Resource
    private TpmActMapper tpmActMapper;
    @Resource
    private TpmActDetailMapper tpmActDetailMapper;
    @Resource
    private TpmCostTypeFineMapper tpmCostTypeFineMapper;
    @Resource
    private TpmAuditMapper tpmAuditMapper;

    public void convertListDate(List<TpmAuditRespVo> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            list.forEach(o -> {
                if (StringUtils.isNotEmpty((CharSequence)o.getApproveStatus())) {
                    o.setApproveStatusName(ActAdvancePayApproveStatusEnum.getStatusName((String)o.getApproveStatus()));
                }
            });
        }
    }

    public void deleteCheck(List<TpmAuditEntity> tpmAuditEntities, List<String> ids) {
        tpmAuditEntities.forEach(tpmAuditEntity -> AssertUtils.isTrue((ActApproveStatusEnum.CREATE.getCode().equals(tpmAuditEntity.getApproveStatus()) || ActApproveStatusEnum.REJECTED.getCode().equals(tpmAuditEntity.getApproveStatus()) || ActApproveStatusEnum.INTERRUPT.getCode().equals(tpmAuditEntity.getApproveStatus()) ? 1 : 0) != 0, (String)"\u5df2\u63d0\u4ea4\u6570\u636e\u4e0d\u80fd\u5220\u9664"));
    }

    public void saveCheck(TpmAuditReqVo reqVo) {
        if (StringUtils.isNotBlank((CharSequence)reqVo.getId())) {
            TpmAuditEntity tpmAuditEntity = (TpmAuditEntity)((Object)this.auditMapper.selectById((Serializable)((Object)reqVo.getId())));
            AssertUtils.isNotNull((Object)((Object)tpmAuditEntity), (CrmExceptionType)AuditException.DATA_NOT_EXIST, (String[])new String[0]);
            AssertUtils.isTrue((boolean)StringUtils.equals((CharSequence)ActAdvancePayApproveStatusEnum.CREATE.getCode(), (CharSequence)reqVo.getApproveStatus()), (String)"\u53ea\u6709\u5f85\u63d0\u4ea4\u7684\u6570\u636e\u5141\u8bb8\u4fee\u6539");
            reqVo.setAuditCode(tpmAuditEntity.getAuditCode());
            reqVo.setFormInstanceId(tpmAuditEntity.getFormInstanceId());
        }
        AssertUtils.isNotEmpty((String)reqVo.getFormInstanceId(), (String)"\u8868\u5355\u5b9e\u4f8b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getAuditName(), (String)"\u6838\u9500\u7533\u8bf7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isTrue((ActApproveStatusEnum.CREATE.getCode().equals(reqVo.getApproveStatus()) || ActApproveStatusEnum.REJECTED.getCode().equals(reqVo.getApproveStatus()) || ActApproveStatusEnum.INTERRUPT.getCode().equals(reqVo.getApproveStatus()) ? 1 : 0) != 0, (String)"\u8be5\u6761\u6570\u636e\u4e0d\u80fd\u518d\u63d0\u4ea4\u5ba1\u6279");
        this.saveActCheckDetails(reqVo);
        this.saveCheckDetails(reqVo);
        this.checkDataExist(reqVo);
    }

    private void saveActCheckDetails(TpmAuditReqVo reqVo) {
        List tpmAuditActReqVos = reqVo.getTpmAuditActReqVos();
        AssertUtils.isNotEmpty((Collection)tpmAuditActReqVos, (String)"\u884c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        List collect = tpmAuditActReqVos.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<TpmAuditActReqVo>(Comparator.comparing(TpmAuditActReqVo::getActCode))), ArrayList::new));
        if (StringUtils.isNotBlank((CharSequence)reqVo.getId())) {
            AssertUtils.isTrue((collect.size() == tpmAuditActReqVos.size() ? 1 : 0) != 0, (String)"\u6d3b\u52a8\u6570\u636e\u91cd\u590d");
            List actCodes = collect.stream().map(TpmAuditActReqVo::getActCode).collect(Collectors.toList());
            List tpmActEntities = this.tpmActMapper.selectList((Wrapper)Wrappers.lambdaQuery().in(TpmActEntity::getActCode, actCodes));
            AssertUtils.isTrue((CollectionUtils.size((Object)tpmActEntities) == tpmAuditActReqVos.size() ? 1 : 0) != 0, (String)"\u6d3b\u52a8\u6570\u636e\u5f02\u5e38");
        }
        collect.forEach(tpmAuditActReqVo -> {
            AssertUtils.isNotEmpty((String)tpmAuditActReqVo.getActCode(), (String)"\u6d3b\u52a8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)tpmAuditActReqVo.getActName(), (String)"\u6d3b\u52a8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            TpmActEntity tpmActEntity = (TpmActEntity)((Object)((Object)this.tpmActMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(TpmActEntity::getActCode, (Object)tpmAuditActReqVo.getActCode()))));
            AssertUtils.isNotNull((Object)((Object)tpmActEntity), (CrmExceptionType)ActException.DATA_NOT_EXIST, (String[])new String[0]);
            AssertUtils.isTrue((boolean)StringUtils.equals((CharSequence)ActApproveStatusEnum.APPROVED.getCode(), (CharSequence)tpmActEntity.getApproveStatus()), (String)"\u5ba1\u6279\u672a\u901a\u8fc7\u7684\u6570\u636e\u4e0d\u80fd\u6838\u9500");
            List tpmActDetailEntities = this.tpmActDetailMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(TpmActDetailEntity::getActCode, (Object)tpmActEntity.getActCode()));
            AssertUtils.isNotEmpty((Collection)tpmActDetailEntities, (CrmExceptionType)ActException.DATA_NOT_EXIST);
            tpmActDetailEntities.stream().forEach(tpmActDetailEntity -> AssertUtils.isTrue((boolean)StringUtils.equals((CharSequence)GlobalWhetherEnum.NO.getCode(), (CharSequence)tpmActDetailEntity.getIsAllAudit()), (String)"\u5b8c\u5168\u6838\u9500\u7684\u6570\u636e\u4e0d\u80fd\u6838\u9500"));
        });
    }

    private void saveCheckDetails(TpmAuditReqVo reqVo) {
        List detailVos = reqVo.getDetailVos();
        AssertUtils.isNotEmpty((Collection)detailVos, (String)"\u884c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        for (int i = 0; i < detailVos.size(); ++i) {
            AssertUtils.isNotEmpty((String)((TpmAuditDetailReqVo)detailVos.get(i)).getPayType(), (String)"\u652f\u4ed8\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)((TpmAuditDetailReqVo)detailVos.get(i)).getPayTypeName(), (String)"\u652f\u4ed8\u65b9\u5f0f\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isNotNull((Object)((TpmAuditDetailReqVo)detailVos.get(i)).getAuditApplyAmount(), (String)"\u672c\u6b21\u6838\u9500\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isNotNull((Object)((TpmAuditDetailReqVo)detailVos.get(i)).getAlreadyAuditAmount(), (String)"\u5df2\u6838\u9500\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
            TpmActDetailEntity tpmActDetail = (TpmActDetailEntity)((Object)this.tpmActDetailMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(TpmActDetailEntity::getActDetailCode, (Object)((TpmAuditDetailReqVo)detailVos.get(i)).getActDetailCode())));
            AssertUtils.isNotNull((Object)((Object)tpmActDetail), (CrmExceptionType)ActException.DATA_NOT_EXIST, (String[])new String[0]);
            TpmCostTypeFineEntity typeFineEntity = (TpmCostTypeFineEntity)((Object)this.tpmCostTypeFineMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(TpmCostTypeFineEntity::getFineCode, (Object)tpmActDetail.getFineCode())));
            AssertUtils.isNotNull((Object)((Object)typeFineEntity), (CrmExceptionType)CostTypeFineException.DATA_NOT_EXIST, (String[])new String[0]);
            AssertUtils.isTrue((boolean)StringUtils.equals((CharSequence)((TpmAuditDetailReqVo)detailVos.get(i)).getFineCode(), (CharSequence)tpmActDetail.getFineCode()), (String)"\u8be5\u6d3b\u52a8\u4e0b\u6ca1\u6709\u8be5\u6d3b\u52a8\u7ec6\u7c7b");
            BigDecimal extraAuditRatio = typeFineEntity.getExtraAuditRatio().add(BigDecimal.ONE);
            BigDecimal auditApplyAmount = ((TpmAuditDetailReqVo)detailVos.get(i)).getAuditApplyAmount();
            BigDecimal addAmount = auditApplyAmount.add(((TpmAuditDetailReqVo)detailVos.get(i)).getAlreadyAuditAmount());
            BigDecimal multiplyAmount = extraAuditRatio.multiply(tpmActDetail.getApplyAmount());
            BigDecimal divideRatio = extraAuditRatio.divide(new BigDecimal(100), 1);
            BigDecimal maxAuditAmount = auditApplyAmount.multiply(divideRatio).subtract(((TpmAuditDetailReqVo)detailVos.get(i)).getAlreadyAuditAmount());
            AssertUtils.isTrue((addAmount.compareTo(multiplyAmount) < 1 ? 1 : 0) != 0, (String)("\u7b2c" + i + "\u884c\u8d85\u8fc7\u5141\u8bb8\u6700\u5927\u6838\u9500\u91d1\u989d:" + maxAuditAmount + ""));
        }
    }

    private void checkDataExist(TpmAuditReqVo reqVo) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(TpmAuditEntity::getAuditCode, (Object)reqVo.getAuditCode());
        if (StringUtils.isNotEmpty((CharSequence)reqVo.getId())) {
            wrapper.ne(BaseIdEntity::getId, (Object)reqVo.getId());
        }
        TpmAuditEntity entity = (TpmAuditEntity)((Object)this.auditMapper.selectOne((Wrapper)wrapper));
        AssertUtils.isTrue((boolean)Objects.isNull((Object)entity), (CrmExceptionType)AuditException.DATA_CODE_DUPLICATE, (String[])new String[0]);
    }

    public void sendToActivity(TpmAuditReqVo reqVo) {
    }
}

