/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.audit.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.act.mapper.TpmActDetailMapper;
import com.biz.crm.act.model.TpmActDetailEntity;
import com.biz.crm.act.service.ITpmActBudgetService;
import com.biz.crm.audit.mapper.TpmAuditActMapper;
import com.biz.crm.audit.mapper.TpmAuditDetailMapper;
import com.biz.crm.audit.mapper.TpmAuditFileMapper;
import com.biz.crm.audit.mapper.TpmAuditMapper;
import com.biz.crm.audit.model.TpmAuditActEntity;
import com.biz.crm.audit.model.TpmAuditDetailEntity;
import com.biz.crm.audit.model.TpmAuditEntity;
import com.biz.crm.audit.model.TpmAuditFileEntity;
import com.biz.crm.audit.service.ITpmAuditActService;
import com.biz.crm.audit.service.ITpmAuditDetailService;
import com.biz.crm.audit.service.ITpmAuditFileService;
import com.biz.crm.audit.service.ITpmAuditService;
import com.biz.crm.audit.service.impl.AuditServiceHelper;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.common.DictItemVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.costtypefine.mapper.TpmCostTypeFineMapper;
import com.biz.crm.costtypefine.model.TpmCostTypeFineEntity;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.GlobalWhetherEnum;
import com.biz.crm.eunm.tpm.ActApproveStatusEnum;
import com.biz.crm.eunm.tpm.ActSaveTypeEnum;
import com.biz.crm.eunm.tpm.AuditFileTypeEnum;
import com.biz.crm.nebular.tpm.act.req.TpmActBudgetReqVo;
import com.biz.crm.nebular.tpm.act.req.TpmActDetailReqVo;
import com.biz.crm.nebular.tpm.act.resp.TpmActBudgetRespVo;
import com.biz.crm.nebular.tpm.act.resp.TpmActDetailRespVo;
import com.biz.crm.nebular.tpm.audit.req.TpmAuditDetailReqVo;
import com.biz.crm.nebular.tpm.audit.req.TpmAuditReqVo;
import com.biz.crm.nebular.tpm.audit.resp.TpmAuditActRespVo;
import com.biz.crm.nebular.tpm.audit.resp.TpmAuditDetailRespVo;
import com.biz.crm.nebular.tpm.audit.resp.TpmAuditFileRespVo;
import com.biz.crm.nebular.tpm.audit.resp.TpmAuditRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DictUtil;
import com.bizunited.platform.common.vo.UuidVo;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
@ConditionalOnMissingBean(name={"TpmAuditServiceExpandImpl"})
public class TpmAuditServiceImpl
extends ServiceImpl<TpmAuditMapper, TpmAuditEntity>
implements ITpmAuditService {
    private static final Logger log = LoggerFactory.getLogger(TpmAuditServiceImpl.class);
    @Resource
    private TpmAuditMapper tpmAuditMapper;
    @Autowired
    private AuditServiceHelper serviceHelper;
    @Resource
    private TpmActDetailMapper tpmActDetailMapper;
    @Autowired
    private ITpmAuditDetailService iTpmAuditDetailService;
    @Autowired
    private ITpmAuditActService iTpmAuditActService;
    @Autowired
    private ITpmActBudgetService iTpmActBudgetService;
    @Resource
    private TpmAuditDetailMapper tpmAuditDetailMapper;
    @Resource
    private TpmAuditActMapper tpmAuditActMapper;
    @Autowired
    private ITpmAuditFileService iTpmAuditFileService;
    @Resource
    private TpmAuditFileMapper tpmAuditFileMapper;
    @Resource
    private TpmCostTypeFineMapper tpmCostTypeFineMapper;

    @Override
    public PageResult<TpmAuditRespVo> findList(TpmAuditReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<TpmAuditRespVo> list = this.tpmAuditMapper.findList((Page<TpmAuditRespVo>)page, reqVo);
        this.serviceHelper.convertListDate(list);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public TpmAuditRespVo query(TpmAuditReqVo reqVo) {
        List tpmAuditFileEntities;
        TpmAuditEntity tpmAuditEntity = (TpmAuditEntity)((Object)this.tpmAuditMapper.selectById((Serializable)((Object)reqVo.getId())));
        if (ObjectUtils.isEmpty((Object)((Object)tpmAuditEntity))) {
            return null;
        }
        TpmAuditRespVo tpmAuditRespVo = (TpmAuditRespVo)CrmBeanUtil.copy((Object)((Object)tpmAuditEntity), TpmAuditRespVo.class);
        this.queryAuditDetail(tpmAuditRespVo);
        List auditActEntityList = this.tpmAuditActMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(TpmAuditActEntity::getAuditCode, (Object)tpmAuditRespVo.getAuditCode()));
        if (CollectionUtils.isNotEmpty((Collection)auditActEntityList)) {
            tpmAuditRespVo.setTpmAuditActReqVos(CrmBeanUtil.copyList((List)auditActEntityList, TpmAuditActRespVo.class));
        }
        if (CollectionUtils.isNotEmpty((Collection)(tpmAuditFileEntities = this.tpmAuditFileMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(TpmAuditFileEntity::getAuditCode, (Object)tpmAuditRespVo.getAuditCode()))))) {
            tpmAuditRespVo.setAuditFileRespVos(CrmBeanUtil.copyList((List)tpmAuditFileEntities, TpmAuditFileRespVo.class));
        }
        return tpmAuditRespVo;
    }

    private void queryAuditDetail(TpmAuditRespVo tpmAuditRespVo) {
        List detailEntityList = this.tpmAuditDetailMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(TpmAuditDetailEntity::getAuditCode, (Object)tpmAuditRespVo.getAuditCode()));
        if (CollectionUtils.isNotEmpty((Collection)detailEntityList)) {
            List tpmAuditDetailRespVos = CrmBeanUtil.copyList((List)detailEntityList, TpmAuditDetailRespVo.class);
            List findCodes = tpmAuditDetailRespVos.stream().map(TpmAuditDetailRespVo::getFineCode).collect(Collectors.toList());
            List tpmCostTypeFineEntities = this.tpmCostTypeFineMapper.selectList((Wrapper)Wrappers.lambdaQuery().in(TpmCostTypeFineEntity::getFineCode, findCodes));
            if (CollectionUtil.listNotEmpty((List)tpmCostTypeFineEntities)) {
                Map<String, List<TpmCostTypeFineEntity>> findCodeGroupMap = tpmCostTypeFineEntities.stream().collect(Collectors.groupingBy(TpmCostTypeFineEntity::getFineCode));
                Map<String, String> dictValueMap = this.queryDictValueMap();
                tpmAuditDetailRespVos.forEach(tpmAuditDetailRespVo -> {
                    TpmCostTypeFineEntity typeFineEntity;
                    String fineCode = tpmAuditDetailRespVo.getFineCode();
                    if (StringUtils.isNotBlank((CharSequence)fineCode) && CollectionUtil.mapNotEmpty((Map)findCodeGroupMap) && StringUtils.isNotEmpty((CharSequence)(typeFineEntity = (TpmCostTypeFineEntity)((Object)((Object)((List)findCodeGroupMap.get(fineCode)).get(0)))).getPayTypeList()) && CollectionUtil.mapNotEmpty((Map)dictValueMap)) {
                        List<DictItemVo> payTypes = this.getPayTypes(typeFineEntity.getPayTypeList(), dictValueMap);
                        tpmAuditDetailRespVo.setPayTypesJsonStr(JSON.toJSONString(payTypes));
                        tpmAuditDetailRespVo.setPayTypes(payTypes);
                    }
                });
                tpmAuditRespVo.setDetailVos(tpmAuditDetailRespVos);
            }
        }
    }

    private List<DictItemVo> getPayTypes(String payTypeList, Map<String, String> map) {
        List codes = JSON.parseArray((String)payTypeList, String.class);
        ArrayList payTypes = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)codes)) {
            codes.forEach(o -> {
                DictItemVo dictItemVo = new DictItemVo();
                String s = (String)map.get(o);
                dictItemVo.setDictKey(s);
                dictItemVo.setDictValue(o);
                payTypes.add(dictItemVo);
            });
        }
        return payTypes;
    }

    private Map<String, String> queryDictValueMap() {
        ArrayList dictCodes = Lists.newArrayList();
        dictCodes.add("pay_type_d");
        Map dictValueMapsByCodes = DictUtil.getDictValueMapsByCodes((List)dictCodes);
        if (!CollectionUtil.mapNotEmpty((Map)dictValueMapsByCodes)) {
            return null;
        }
        Map map = (Map)dictValueMapsByCodes.get("pay_type_d");
        return map;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(TpmAuditReqVo reqVo) {
        this.serviceHelper.saveCheck(reqVo);
        TpmAuditEntity entity = (TpmAuditEntity)((Object)CrmBeanUtil.copy((Object)reqVo, TpmAuditEntity.class));
        entity.setAuditCode(CodeUtil.createOneCode((String)"tpm_audit"));
        this.save((Object)entity);
        this.saveAuditDetailInfo(reqVo, entity);
        this.saveAuditActInfo(reqVo, entity);
        this.saveAuditFileInfo(reqVo, entity);
        if (ActSaveTypeEnum.ADD_AND_APPROVE.getCode().equals(reqVo.getSaveType())) {
            for (TpmAuditDetailReqVo detailVo : reqVo.getDetailVos()) {
                BigDecimal auditAmount;
                if (!StringUtils.equals((CharSequence)detailVo.getIsAllAudit(), (CharSequence)GlobalWhetherEnum.YES.getCode()) || (auditAmount = detailVo.getAlreadyAuditAmount().add(detailVo.getAuditApplyAmount())).compareTo(detailVo.getActDetailApplyAmount()) != 1) continue;
                BigDecimal occupiedAmount = auditAmount.subtract(detailVo.getActDetailApplyAmount());
                this.addActFeeBudgetDetail(detailVo, occupiedAmount);
            }
        }
    }

    private void saveAuditFileInfo(TpmAuditReqVo reqVo, TpmAuditEntity entity) {
        List typeFineRespVos = reqVo.getAuditFileRespVos();
        if (CollectionUtil.listNotEmpty((List)typeFineRespVos)) {
            List tpmAuditFileEntities = CrmBeanUtil.copyList((List)typeFineRespVos, TpmAuditFileEntity.class);
            tpmAuditFileEntities.forEach(tpmAuditFileEntity -> {
                tpmAuditFileEntity.setAuditCode(entity.getAuditCode());
                tpmAuditFileEntity.setAuditFileType(AuditFileTypeEnum.AUDIT_INFORMATION.getCode());
                tpmAuditFileEntity.setFormInstanceId(entity.getFormInstanceId());
            });
            this.iTpmAuditFileService.saveBatch(tpmAuditFileEntities);
        }
    }

    public void saveAuditDetailInfo(TpmAuditReqVo reqVo, TpmAuditEntity entity) {
        List detailVos = reqVo.getDetailVos();
        detailVos.forEach(o -> {
            o.setAuditDetailCode(CodeUtil.createOneCode((String)"tpm_audit_detail"));
            o.setAuditCode(entity.getAuditCode());
            o.setFormInstanceId(entity.getFormInstanceId());
            if (o.getFeeUsed() == null) {
                o.setFeeUsed(BigDecimal.ZERO);
            }
            if (StringUtils.isBlank((CharSequence)o.getIsAllFeeUsed())) {
                o.setIsAllFeeUsed(GlobalWhetherEnum.NO.getCode());
            }
        });
        List tpmAuditDetailEntities = CrmBeanUtil.copyList((List)detailVos, TpmAuditDetailEntity.class);
        this.iTpmAuditDetailService.saveBatch(tpmAuditDetailEntities);
    }

    public void saveAuditActInfo(TpmAuditReqVo reqVo, TpmAuditEntity entity) {
        List tpmAuditActReqVos = reqVo.getTpmAuditActReqVos();
        tpmAuditActReqVos.forEach(o -> {
            o.setAuditCode(entity.getAuditCode());
            o.setFormInstanceId(entity.getAuditCode());
        });
        List tpmAuditActEntities = CrmBeanUtil.copyList((List)tpmAuditActReqVos, TpmAuditActEntity.class);
        this.iTpmAuditActService.saveBatch(tpmAuditActEntities);
    }

    private void addActFeeBudgetDetail(TpmAuditDetailReqVo detailVo, BigDecimal occupiedAmount) {
        TpmActBudgetReqVo tpmActBudgetReqVo = new TpmActBudgetReqVo();
        tpmActBudgetReqVo.setActCode(detailVo.getActCode());
        TpmActBudgetRespVo budgetRespVo = this.iTpmActBudgetService.query(tpmActBudgetReqVo);
        if (budgetRespVo != null) {
            TpmActDetailEntity tpmActDetailEntity = (TpmActDetailEntity)((Object)this.tpmActDetailMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(TpmActDetailEntity::getActDetailCode, (Object)detailVo.getActDetailCode())));
            String string = budgetRespVo.getFeeBudgetCode();
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(TpmAuditReqVo reqVo) {
        this.serviceHelper.saveCheck(reqVo);
        TpmAuditEntity tpmAuditEntity = (TpmAuditEntity)((Object)CrmBeanUtil.copy((Object)reqVo, TpmAuditEntity.class));
        this.updateById((Object)tpmAuditEntity);
        this.updateAuditDetail(reqVo, tpmAuditEntity);
        this.updateAct(reqVo, tpmAuditEntity);
        this.updateAuditFile(reqVo, tpmAuditEntity);
    }

    public void updateAct(TpmAuditReqVo reqVo, TpmAuditEntity tpmAuditEntity) {
        List tpmAuditActReqVos = reqVo.getTpmAuditActReqVos();
        tpmAuditActReqVos.stream().forEach(tpmAuditActReqVo -> {
            tpmAuditActReqVo.setFormInstanceId(tpmAuditEntity.getFormInstanceId());
            tpmAuditActReqVo.setAuditCode(tpmAuditEntity.getAuditCode());
        });
        List auditActIds = tpmAuditActReqVos.stream().map(UuidVo::getId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(auditActIds)) {
            this.tpmAuditActMapper.delete((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TpmAuditActEntity::getAuditCode, (Object)tpmAuditEntity.getAuditCode())).notIn(BaseIdEntity::getId, auditActIds));
        }
        this.iTpmAuditActService.saveOrUpdateBatch(CrmBeanUtil.copyList((List)tpmAuditActReqVos, TpmAuditActEntity.class));
    }

    public void updateAuditDetail(TpmAuditReqVo reqVo, TpmAuditEntity tpmAuditEntity) {
        List detailVos = reqVo.getDetailVos();
        detailVos.stream().forEach(detailReqVo -> {
            detailReqVo.setFormInstanceId(tpmAuditEntity.getFormInstanceId());
            detailReqVo.setAuditCode(tpmAuditEntity.getAuditCode());
        });
        List auditDetailIds = detailVos.stream().filter(o -> StringUtils.isNotBlank((CharSequence)o.getId())).map(UuidVo::getId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(auditDetailIds)) {
            this.tpmAuditDetailMapper.delete((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TpmAuditDetailEntity::getAuditCode, (Object)tpmAuditEntity.getAuditCode())).notIn(BaseIdEntity::getId, auditDetailIds));
        }
        this.iTpmAuditDetailService.saveOrUpdateBatch(CrmBeanUtil.copyList((List)detailVos, TpmAuditDetailEntity.class));
    }

    public void updateAuditFile(TpmAuditReqVo reqVo, TpmAuditEntity tpmAuditEntity) {
        List auditFileRespVos = reqVo.getAuditFileRespVos();
        if (CollectionUtils.isNotEmpty((Collection)auditFileRespVos)) {
            auditFileRespVos.stream().forEach(tpmAuditFileRespVo -> {
                tpmAuditFileRespVo.setFormInstanceId(tpmAuditEntity.getFormInstanceId());
                tpmAuditFileRespVo.setAuditCode(tpmAuditEntity.getAuditCode());
            });
            List auditFileIds = auditFileRespVos.stream().map(UuidVo::getId).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(auditFileIds)) {
                this.tpmAuditFileMapper.delete((Wrapper)Wrappers.lambdaQuery().eq(TpmAuditFileEntity::getAuditCode, (Object)tpmAuditEntity.getAuditCode()));
            }
            this.iTpmAuditFileService.saveBatch(CrmBeanUtil.copyList((List)auditFileRespVos, TpmAuditFileEntity.class));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        List tpmAuditEntities = this.tpmAuditMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)tpmAuditEntities)) {
            this.serviceHelper.deleteCheck(tpmAuditEntities, ids);
            List auditCodes = tpmAuditEntities.stream().map(TpmAuditEntity::getAuditCode).collect(Collectors.toList());
            this.tpmAuditDetailMapper.delete((Wrapper)Wrappers.lambdaQuery().in(TpmAuditDetailEntity::getAuditCode, auditCodes));
            this.tpmAuditActMapper.delete((Wrapper)Wrappers.lambdaQuery().in(TpmAuditActEntity::getAuditCode, auditCodes));
            this.tpmAuditMapper.deleteBatchIds(ids);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(TpmAuditReqVo reqVo) {
        List tpmAuditEntities = this.tpmAuditMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)tpmAuditEntities)) {
            tpmAuditEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(tpmAuditEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(TpmAuditReqVo reqVo) {
        List tpmAuditEntities = this.tpmAuditMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)tpmAuditEntities)) {
            tpmAuditEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(tpmAuditEntities);
    }

    @Override
    public PageResult<TpmActDetailRespVo> findActDetailList(TpmActDetailReqVo tpmActDetailReqVo) {
        AssertUtils.isNotEmpty((Collection)tpmActDetailReqVo.getActCodes(), (String)"\u6d3b\u52a8\u7f16\u7801\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        Page page = new Page((long)tpmActDetailReqVo.getPageNum().intValue(), (long)tpmActDetailReqVo.getPageSize().intValue());
        List<TpmActDetailRespVo> list = this.tpmActDetailMapper.findActDetailList((Page<TpmActDetailRespVo>)page, tpmActDetailReqVo);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        Map<String, String> dictValueMap = this.queryDictValueMap();
        list.forEach(tpmActDetailRespVo -> {
            if (StringUtils.isNotEmpty((CharSequence)tpmActDetailRespVo.getPayTypeList()) && CollectionUtil.mapNotEmpty((Map)dictValueMap)) {
                List<DictItemVo> payTypes = this.getPayTypes(tpmActDetailRespVo.getPayTypeList(), dictValueMap);
                tpmActDetailRespVo.setPayTypesJsonStr(JSON.toJSONString(payTypes));
                tpmActDetailRespVo.setPayTypes(payTypes);
            }
        });
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void auditApproved(TpmAuditReqVo tpmAuditReqVo) {
        AssertUtils.isNotEmpty((Collection)tpmAuditReqVo.getIds(), (String)"\u7f16\u7801\u96c6\u5408\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        List tpmAuditEntities = this.tpmAuditMapper.selectBatchIds(tpmAuditReqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)tpmAuditEntities)) {
            tpmAuditEntities.forEach(o -> o.setApproveStatus(ActApproveStatusEnum.APPROVED.getCode()));
        }
        this.updateBatchById(tpmAuditEntities);
    }

    private void refundActFeeBudgetDetail(List<TpmAuditDetailEntity> detailEntityList, BigDecimal refundAmount) {
    }
}

