/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.costtypecategories.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.common.TpmGlobalDictConstants;
import com.biz.crm.costtypecategories.mapper.TpmCostTypeCategoriesFineMapper;
import com.biz.crm.costtypecategories.mapper.TpmCostTypeCategoriesMapper;
import com.biz.crm.costtypecategories.mapper.TpmCostTypeCategoriesRangeMapper;
import com.biz.crm.costtypecategories.model.TpmCostTypeCategoriesEntity;
import com.biz.crm.costtypecategories.service.ITpmCostTypeCategoriesFineService;
import com.biz.crm.costtypecategories.service.ITpmCostTypeCategoriesRangeService;
import com.biz.crm.costtypecategories.service.ITpmCostTypeCategoriesService;
import com.biz.crm.costtypecategories.service.impl.CostTypeCategoriesServiceHelper;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.SelectAllFlagEnum;
import com.biz.crm.exception.CommonException;
import com.biz.crm.exception.CrmExceptionType;
import com.biz.crm.exception.tpm.CostTypeCategoriesException;
import com.biz.crm.nebular.tpm.act.req.ActGetCategoriesByBudgetReqVo;
import com.biz.crm.nebular.tpm.costtypecategories.req.TpmCostTypeCategoriesFineReqVo;
import com.biz.crm.nebular.tpm.costtypecategories.req.TpmCostTypeCategoriesRangeReqVo;
import com.biz.crm.nebular.tpm.costtypecategories.req.TpmCostTypeCategoriesReqVo;
import com.biz.crm.nebular.tpm.costtypecategories.resp.TpmCostTypeCategoriesRangeRespVo;
import com.biz.crm.nebular.tpm.costtypecategories.resp.TpmCostTypeCategoriesRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"TmpCostTypeCategoriesServiceExpandImpl"})
public class TpmCostTypeCategoriesServiceImpl
extends ServiceImpl<TpmCostTypeCategoriesMapper, TpmCostTypeCategoriesEntity>
implements ITpmCostTypeCategoriesService {
    private static final Logger log = LoggerFactory.getLogger(TpmCostTypeCategoriesServiceImpl.class);
    @Resource
    private TpmCostTypeCategoriesMapper tpmCostTypeCategoriesMapper;
    @Autowired
    private CostTypeCategoriesServiceHelper serviceHelper;
    @Autowired
    private ITpmCostTypeCategoriesFineService fineService;
    @Autowired
    private ITpmCostTypeCategoriesRangeService rangeService;
    @Resource
    private TpmCostTypeCategoriesRangeMapper rangeMapper;
    @Resource
    private TpmCostTypeCategoriesFineMapper fineMapper;

    @Override
    @CrmLog
    public PageResult<TpmCostTypeCategoriesRespVo> findList(TpmCostTypeCategoriesReqVo tpmCostTypeCategoriesReqVo) {
        Page page = new Page((long)tpmCostTypeCategoriesReqVo.getPageNum().intValue(), (long)tpmCostTypeCategoriesReqVo.getPageSize().intValue());
        List<TpmCostTypeCategoriesRespVo> list = this.tpmCostTypeCategoriesMapper.findList((Page<TpmCostTypeCategoriesRespVo>)page, tpmCostTypeCategoriesReqVo);
        this.serviceHelper.convertListDate(list);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @CrmLog
    public TpmCostTypeCategoriesRespVo query(TpmCostTypeCategoriesReqVo tpmCostTypeCategoriesReqVo) {
        List list = this.findList(tpmCostTypeCategoriesReqVo).getData();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new TpmCostTypeCategoriesRespVo();
        }
        TpmCostTypeCategoriesRespVo respVo = (TpmCostTypeCategoriesRespVo)list.get(0);
        TpmCostTypeCategoriesRangeReqVo rangeReqVo = new TpmCostTypeCategoriesRangeReqVo();
        rangeReqVo.setPageSize(Integer.valueOf(-1));
        rangeReqVo.setCategoriesCode(respVo.getCategoriesCode());
        List rangeVos = this.rangeService.findList(rangeReqVo).getData();
        Map<String, List<TpmCostTypeCategoriesRangeRespVo>> map = rangeVos.stream().collect(Collectors.groupingBy(o -> o.getRangeType() + o.getIsContain()));
        map.keySet().forEach(o -> {
            List vos = (List)map.get(o);
            if (StringUtils.equals((CharSequence)(TpmGlobalDictConstants.RANGE_ORG + "Y"), (CharSequence)o)) {
                respVo.setContainOrgRangeVos(vos);
            } else if (StringUtils.equals((CharSequence)(TpmGlobalDictConstants.RANGE_ORG + "N"), (CharSequence)o)) {
                respVo.setNonContainOrgRangeVos(vos);
            } else if (StringUtils.equals((CharSequence)(TpmGlobalDictConstants.RANGE_ORG_TYPE + "Y"), (CharSequence)o)) {
                respVo.setContainOrgTypeRangeVos(vos);
            } else if (StringUtils.equals((CharSequence)(TpmGlobalDictConstants.RANGE_ORG_TYPE + "N"), (CharSequence)o)) {
                respVo.setNonContainOrgTypeRangeVos(vos);
            } else {
                throw new BusinessException("\u6d3b\u52a8\u5927\u7c7b" + respVo.getCategoriesCode() + "\u8303\u56f4\u4fe1\u606f\u6570\u636e\u5f02\u5e38");
            }
        });
        TpmCostTypeCategoriesFineReqVo fineReqVo = new TpmCostTypeCategoriesFineReqVo();
        fineReqVo.setPageSize(Integer.valueOf(-1));
        fineReqVo.setCategoriesCode(respVo.getCategoriesCode());
        List fineVos = this.fineService.findList(fineReqVo).getData();
        respVo.setFineVos(fineVos);
        return respVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void save(TpmCostTypeCategoriesReqVo reqVo) {
        this.serviceHelper.saveCheck(reqVo);
        TpmCostTypeCategoriesEntity entity = (TpmCostTypeCategoriesEntity)((Object)CrmBeanUtil.copy((Object)reqVo, TpmCostTypeCategoriesEntity.class));
        this.save((Object)entity);
        this.serviceHelper.saveRanges(reqVo);
        this.serviceHelper.saveFines(reqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void update(TpmCostTypeCategoriesReqVo reqVo) {
        if (StringUtils.isEmpty((CharSequence)reqVo.getId())) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        TpmCostTypeCategoriesEntity entity = (TpmCostTypeCategoriesEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        AssertUtils.isNotNull((Object)((Object)entity), (CrmExceptionType)CostTypeCategoriesException.DATA_NOT_EXIST, (String[])new String[0]);
        this.serviceHelper.saveCheck(reqVo);
        CrmBeanUtil.copyProperties((Object)reqVo, (Object)((Object)entity));
        this.updateById((Object)entity);
        this.serviceHelper.saveRanges(reqVo);
        this.serviceHelper.saveFines(reqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void deleteBatch(TpmCostTypeCategoriesReqVo tpmCostTypeCategoriesReqVo) {
        AssertUtils.isNotEmpty((Collection)tpmCostTypeCategoriesReqVo.getIds(), (CrmExceptionType)CommonException.IDS_NULL);
        this.serviceHelper.deleteCheck(tpmCostTypeCategoriesReqVo);
        this.tpmCostTypeCategoriesMapper.deleteByParams(tpmCostTypeCategoriesReqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void enableBatch(TpmCostTypeCategoriesReqVo reqVo) {
        if (StringUtils.equals((CharSequence)SelectAllFlagEnum.ALL.getCode(), (CharSequence)reqVo.getSelectAllFlag())) {
            TpmCostTypeCategoriesEntity entity = new TpmCostTypeCategoriesEntity();
            entity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            this.serviceHelper.updateBySelectAll(reqVo, entity);
        } else {
            AssertUtils.isNotEmpty((Collection)reqVo.getIds(), (CrmExceptionType)CommonException.IDS_NULL);
            List entities = this.tpmCostTypeCategoriesMapper.selectBatchIds(reqVo.getIds());
            if (CollectionUtils.isNotEmpty((Collection)entities)) {
                entities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
            }
            this.updateBatchById(entities);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void disableBatch(TpmCostTypeCategoriesReqVo reqVo) {
        if (StringUtils.equals((CharSequence)SelectAllFlagEnum.ALL.getCode(), (CharSequence)reqVo.getSelectAllFlag())) {
            TpmCostTypeCategoriesEntity entity = new TpmCostTypeCategoriesEntity();
            entity.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            this.serviceHelper.updateBySelectAll(reqVo, entity);
        } else {
            AssertUtils.isNotEmpty((Collection)reqVo.getIds(), (CrmExceptionType)CommonException.IDS_NULL);
            List entities = this.tpmCostTypeCategoriesMapper.selectBatchIds(reqVo.getIds());
            if (CollectionUtils.isNotEmpty((Collection)entities)) {
                entities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
            }
            this.updateBatchById(entities);
        }
    }

    @Override
    public List<TpmCostTypeCategoriesRespVo> getCategoriesByBudget(ActGetCategoriesByBudgetReqVo reqVo) {
        AssertUtils.isNotEmpty((Collection)reqVo.getControlIds(), (String)"\u8d39\u7528\u9884\u7b97\u63a7\u5236\u7ef4\u5ea6id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getActType(), (String)"\u6d3b\u52a8\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        UserRedis user = UserUtils.getUser();
        if (Objects.nonNull(user)) {
            ArrayList rangeCodes = Lists.newArrayList();
            rangeCodes.add(user.getOrgcode());
            if (Objects.nonNull(user.getType())) {
                rangeCodes.add(user.getType().toString());
            }
            reqVo.setRangeCodes((List)rangeCodes);
        }
        List<TpmCostTypeCategoriesRespVo> respVos = this.tpmCostTypeCategoriesMapper.getCategoriesByBudget(reqVo);
        return respVos;
    }
}

