/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.costtypefine.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.auditcollectexample.mapper.TpmAuditCollectExampleMapper;
import com.biz.crm.auditcollectexample.mapper.TpmAuditCollectExamplePictureMapper;
import com.biz.crm.auditcollectexample.model.TpmAuditCollectExampleEntity;
import com.biz.crm.auditcollectexample.model.TpmAuditCollectExamplePictureEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.DictItemVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.costtypefine.mapper.TpmCostTypeFineMapper;
import com.biz.crm.costtypefine.model.TpmCostTypeFineEntity;
import com.biz.crm.costtypefine.service.ITpmCostTypeFineService;
import com.biz.crm.costtypefine.service.impl.CostTypeFineServiceHelper;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.SelectAllFlagEnum;
import com.biz.crm.exception.CommonException;
import com.biz.crm.exception.CrmExceptionType;
import com.biz.crm.exception.tpm.CostTypeFineException;
import com.biz.crm.nebular.tpm.auditcollectexample.resp.TpmAuditCollectExamplePictureRespVo;
import com.biz.crm.nebular.tpm.auditcollectexample.resp.TpmAuditCollectExampleRespVo;
import com.biz.crm.nebular.tpm.costtypecategories.resp.TpmCostTypeCategoriesRespVo;
import com.biz.crm.nebular.tpm.costtypefine.req.TpmCostTypeFineReqVo;
import com.biz.crm.nebular.tpm.costtypefine.resp.TpmCostTypeFineRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CrmBeanUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"TpmCostTypeFineServiceExpandImpl"})
public class TpmCostTypeFineServiceImpl
extends ServiceImpl<TpmCostTypeFineMapper, TpmCostTypeFineEntity>
implements ITpmCostTypeFineService {
    private static final Logger log = LoggerFactory.getLogger(TpmCostTypeFineServiceImpl.class);
    @Resource
    private TpmCostTypeFineMapper tpmCostTypeFineMapper;
    @Autowired
    private CostTypeFineServiceHelper serviceHelper;
    @Resource
    private TpmAuditCollectExampleMapper tpmAuditCollectExampleMapper;
    @Resource
    private TpmAuditCollectExamplePictureMapper tpmAuditCollectExamplePictureMapper;

    @Override
    @CrmLog
    public PageResult<TpmCostTypeFineRespVo> findList(TpmCostTypeFineReqVo tpmCostTypeFineReqVo) {
        Page page = new Page((long)tpmCostTypeFineReqVo.getPageNum().intValue(), (long)tpmCostTypeFineReqVo.getPageSize().intValue());
        List<TpmCostTypeFineRespVo> list = this.tpmCostTypeFineMapper.findList((Page<TpmCostTypeFineRespVo>)page, tpmCostTypeFineReqVo);
        this.serviceHelper.convertListDate(list);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @CrmLog
    public TpmCostTypeFineRespVo query(TpmCostTypeFineReqVo reqVo) {
        List list = this.findList(reqVo).getData();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new TpmCostTypeFineRespVo();
        }
        TpmCostTypeFineRespVo respVo = (TpmCostTypeFineRespVo)list.get(0);
        if (StringUtils.isNotEmpty((CharSequence)respVo.getCollectRequireList())) {
            List<TpmAuditCollectExampleRespVo> collectRequires = this.serviceHelper.getExamples(respVo.getCollectRequireList());
            respVo.setCollectRequires(collectRequires);
        }
        if (StringUtils.isNotEmpty((CharSequence)respVo.getAuditRequireList())) {
            List<TpmAuditCollectExampleRespVo> auditRequires = this.serviceHelper.getExamples(respVo.getAuditRequireList());
            respVo.setAuditRequires(auditRequires);
        }
        if (StringUtils.isNotEmpty((CharSequence)respVo.getPayTypeList())) {
            List<DictItemVo> payTypes = this.serviceHelper.getPayTypes(respVo.getPayTypeList());
            respVo.setPayTypes(payTypes);
        }
        return respVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void save(TpmCostTypeFineReqVo reqVo) {
        this.serviceHelper.saveCheck(reqVo);
        TpmCostTypeFineEntity entity = (TpmCostTypeFineEntity)((Object)CrmBeanUtil.copy((Object)reqVo, TpmCostTypeFineEntity.class));
        this.save((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void update(TpmCostTypeFineReqVo reqVo) {
        if (StringUtils.isEmpty((CharSequence)reqVo.getId())) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        TpmCostTypeFineEntity entity = (TpmCostTypeFineEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        if (Objects.isNull((Object)entity)) {
            throw new BusinessException((CrmExceptionType)CostTypeFineException.DATA_NOT_EXIST);
        }
        this.serviceHelper.saveCheck(reqVo);
        CrmBeanUtil.copyProperties((Object)reqVo, (Object)((Object)entity));
        this.updateById((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void deleteBatch(TpmCostTypeFineReqVo reqVo) {
        if (StringUtils.equals((CharSequence)SelectAllFlagEnum.ALL.getCode(), (CharSequence)reqVo.getSelectAllFlag())) {
            this.tpmCostTypeFineMapper.deleteProductsByParams(reqVo);
        } else {
            AssertUtils.isNotEmpty((Collection)reqVo.getIds(), (CrmExceptionType)CommonException.IDS_NULL);
            this.tpmCostTypeFineMapper.deleteProductsByParams(reqVo);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void enableBatch(TpmCostTypeFineReqVo reqVo) {
        if (StringUtils.equals((CharSequence)SelectAllFlagEnum.ALL.getCode(), (CharSequence)reqVo.getSelectAllFlag())) {
            TpmCostTypeFineEntity entity = new TpmCostTypeFineEntity();
            entity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            this.serviceHelper.updateBySelectAll(reqVo, entity);
        } else {
            AssertUtils.isNotEmpty((Collection)reqVo.getIds(), (CrmExceptionType)CommonException.IDS_NULL);
            List entities = this.tpmCostTypeFineMapper.selectBatchIds(reqVo.getIds());
            if (CollectionUtils.isNotEmpty((Collection)entities)) {
                entities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
            }
            this.updateBatchById(entities);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void disableBatch(TpmCostTypeFineReqVo reqVo) {
        if (StringUtils.equals((CharSequence)SelectAllFlagEnum.ALL.getCode(), (CharSequence)reqVo.getSelectAllFlag())) {
            TpmCostTypeFineEntity entity = new TpmCostTypeFineEntity();
            entity.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            this.serviceHelper.updateBySelectAll(reqVo, entity);
        } else {
            AssertUtils.isNotEmpty((Collection)reqVo.getIds(), (CrmExceptionType)CommonException.IDS_NULL);
            List entities = this.tpmCostTypeFineMapper.selectBatchIds(reqVo.getIds());
            if (CollectionUtils.isNotEmpty((Collection)entities)) {
                entities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
            }
            this.updateBatchById(entities);
        }
    }

    @Override
    public List<TpmCostTypeFineRespVo> costTypeFineListByFineCode(List<String> fineCodes) {
        this.serviceHelper.costTypeFineListByFineCodeCheck(fineCodes);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.in((Object)"fine_code", fineCodes);
        List tpmCostTypeFineEntities = this.tpmCostTypeFineMapper.selectList((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)tpmCostTypeFineEntities)) {
            return null;
        }
        List tpmCostTypeFineRespVos = CrmBeanUtil.copyList((List)tpmCostTypeFineEntities, TpmCostTypeFineRespVo.class);
        List<String> auditRequireList = tpmCostTypeFineRespVos.stream().map(TpmCostTypeFineRespVo::getAuditRequireList).collect(Collectors.toList());
        ArrayList codes = new ArrayList();
        auditRequireList.forEach(listJson -> codes.addAll(JSON.parseArray((String)listJson, String.class)));
        List<String> auditRequireCodes = codes.stream().distinct().collect(Collectors.toList());
        Map<String, TpmAuditCollectExampleRespVo> exampleMap = this.getExampleMap(auditRequireCodes);
        tpmCostTypeFineRespVos.forEach(tpmCostTypeFineRespVo -> {
            if (StringUtils.isNotEmpty((CharSequence)tpmCostTypeFineRespVo.getAuditRequireList())) {
                List auditRequires = JSON.parseArray((String)tpmCostTypeFineRespVo.getAuditRequireList(), String.class);
                ArrayList collectExampleRespVos = new ArrayList();
                auditRequires.forEach(exampleCode -> {
                    TpmAuditCollectExampleRespVo exampleRespVo = (TpmAuditCollectExampleRespVo)exampleMap.get(exampleCode);
                    collectExampleRespVos.add(exampleRespVo);
                });
                tpmCostTypeFineRespVo.setAuditRequires(collectExampleRespVos);
            }
        });
        return tpmCostTypeFineRespVos;
    }

    private Map<String, TpmAuditCollectExampleRespVo> getExampleMap(List<String> auditRequireCodes) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().in(TpmAuditCollectExampleEntity::getExampleCode, auditRequireCodes);
        LambdaQueryWrapper pictureQueryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().in(TpmAuditCollectExamplePictureEntity::getExampleCode, auditRequireCodes);
        List exampleEntities = this.tpmAuditCollectExampleMapper.selectList((Wrapper)queryWrapper);
        List examplePictureEntities = this.tpmAuditCollectExamplePictureMapper.selectList((Wrapper)pictureQueryWrapper);
        HashMap<String, TpmAuditCollectExampleRespVo> nameMap = new HashMap<String, TpmAuditCollectExampleRespVo>();
        if (CollectionUtils.isNotEmpty((Collection)exampleEntities)) {
            Map<String, List<TpmAuditCollectExampleEntity>> collect = exampleEntities.stream().collect(Collectors.groupingBy(TpmAuditCollectExampleEntity::getExampleCode));
            for (Map.Entry<String, List<TpmAuditCollectExampleEntity>> stringListEntry : collect.entrySet()) {
                TpmAuditCollectExampleEntity tpmAuditCollectExampleEntity = stringListEntry.getValue().get(0);
                TpmAuditCollectExampleRespVo collectExampleRespVo = (TpmAuditCollectExampleRespVo)CrmBeanUtil.copy((Object)((Object)tpmAuditCollectExampleEntity), TpmAuditCollectExampleRespVo.class);
                if (CollectionUtils.isNotEmpty((Collection)examplePictureEntities)) {
                    Map<String, List<TpmAuditCollectExamplePictureEntity>> pictureMap = examplePictureEntities.stream().collect(Collectors.groupingBy(TpmAuditCollectExamplePictureEntity::getExampleCode));
                    for (Map.Entry<String, List<TpmAuditCollectExamplePictureEntity>> listEntry : pictureMap.entrySet()) {
                        if (!StringUtils.equals((CharSequence)stringListEntry.getKey(), (CharSequence)listEntry.getKey())) continue;
                        collectExampleRespVo.setPictureRespVos(CrmBeanUtil.copyList(listEntry.getValue(), TpmAuditCollectExamplePictureRespVo.class));
                    }
                }
                nameMap.put(stringListEntry.getKey(), collectExampleRespVo);
            }
        }
        return nameMap;
    }

    @Override
    public PageResult<TpmCostTypeCategoriesRespVo> findCategoriesByFineCode(TpmCostTypeFineReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getFineCode(), (String)"\u6d3b\u52a8\u7ec6\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<TpmCostTypeCategoriesRespVo> list = this.tpmCostTypeFineMapper.findCategoriesByFineCode((Page<TpmCostTypeCategoriesRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }
}

