package com.biz.crm.account.controller;

import com.biz.crm.account.service.ITpmAccountDetailService;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.audit.service.ITpmAuditDetailService;
import com.biz.crm.common.DictItemVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.costtypefine.service.ITpmCostTypeFineService;
import com.biz.crm.liqueraudit.service.ITpmLiqueurAuditAttachService;
import com.biz.crm.nebular.tpm.account.req.*;
import com.biz.crm.nebular.tpm.account.resp.TpmAccountDetailMainRespVo;
import com.biz.crm.nebular.tpm.account.resp.TpmAccountDetailRespVo;
import com.biz.crm.nebular.tpm.audit.req.TpmAuditDetailReqVo;
import com.biz.crm.nebular.tpm.audit.resp.TpmAuditDetailRespVo;
import com.biz.crm.nebular.tpm.costtypefine.resp.TpmCostTypeFineRespVo;
import com.biz.crm.nebular.tpm.liqueuraudit.req.TpmLiqueurAuditAttachReqVo;
import com.biz.crm.nebular.tpm.liqueuraudit.resp.TpmLiqueurAuditAttachRespVo;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 费用上账表;
 *
 * @author zeyi
 * @date 2020-10-12 17:26:54
 */
@Slf4j
@RestController
@RequestMapping("/tpmAccountDetailController")
@Api(tags = "费用上账表;")
public class TpmAccountDetailController {
    @Autowired
    private ITpmAccountDetailService tpmAccountDetailService;

    @Autowired
    private ITpmAuditDetailService tpmAuditDetailService;

    @Autowired
    private ITpmCostTypeFineService tpmCostTypeFineService;

    @Autowired
    private ITpmLiqueurAuditAttachService tpmLiqueurAuditAttachService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<TpmAccountDetailRespVo>> list(@RequestBody TpmAccountDetailReqVo tpmAccountDetailReqVo) {
        PageResult<TpmAccountDetailRespVo> result = tpmAccountDetailService.findList(tpmAccountDetailReqVo);
        return Result.ok(result);
    }

    /**
     * 查看
     */
    @ApiOperation(value = "查看")
    @GetMapping("/queryView")
    @CrmLog
    public Result<TpmAccountDetailMainRespVo> queryView(@RequestParam(value = "id", required = false) String id) {
        TpmAccountDetailMainRespVo respVo = tpmAccountDetailService.queryView(id);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody TpmAccountDetailMainReqVo accountDetailMainReqVo) {
        UserRedis user = UserUtils.getUser();
        accountDetailMainReqVo.setLockUserName(user.getUsername());
        tpmAccountDetailService.save(accountDetailMainReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody TpmAccountDetailMainReqVo accountDetailMainReqVo) {
        UserRedis user = UserUtils.getUser();
        accountDetailMainReqVo.setLockUserName(user.getUsername());
        tpmAccountDetailService.update(accountDetailMainReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        tpmAccountDetailService.deleteBatch(ids);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody List<String> ids) {
        tpmAccountDetailService.enableBatch(ids);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {
        tpmAccountDetailService.disableBatch(ids);
        return Result.ok("禁用成功");
    }

    /**
     * 批量修改支付方式
     */
    @ApiOperation(value = "批量修改支付方式")
    @PostMapping("/batchUpdatePayType")
    @CrmLog
    public Result batchUpdatePayType(@RequestBody TpmAccountUpdatePayTypeReqVo updatePayTypeReqVo) {
        tpmAccountDetailService.batchUpdatePayType(updatePayTypeReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 根据支付方式类型和活动细类集合查询支付方式
     */
    @ApiOperation(value = "根据支付方式类型和活动细类集合查询支付方式")
    @PostMapping("/payTypeByTypeAndFine")
    @CrmLog
    public Result<List<DictItemVo>> payTypeByTypeAndFine(@RequestBody TpmPayTypeByTypeAndFineVo typeAndFineVo) {
        List<DictItemVo> respVo = tpmAccountDetailService.payTypeByTypeAndFine(typeAndFineVo);
        return Result.ok(respVo);
    }

    /**
     * 上账核销明细查询  费用上账新增
     */
    @ApiOperation(value = "上账核销明细查询")
    @PostMapping("/findAccountAuditDetail")
    @CrmLog
    public Result<PageResult<TpmAuditDetailRespVo>> findAccountAuditDetail(@RequestBody TpmAuditDetailReqVo tpmAuditDetailReqVo) {
        PageResult<TpmAuditDetailRespVo> result = tpmAuditDetailService.findAccountAuditDetail(tpmAuditDetailReqVo);
        return Result.ok(result);
    }

    /**
     * 酒类上账核销附加信息查询  费用上账新增
     */
    @ApiOperation(value = "酒类费用上账弹窗查询核销明细接口")
    @PostMapping("/findLiqueurAccountAuditAttach")
    @CrmLog
    public Result<PageResult<TpmLiqueurAuditAttachRespVo>> findLiqueurAccountAuditAttach(@RequestBody TpmLiqueurAuditAttachReqVo tpmLiqueurAuditAttachReqVo) {
        PageResult<TpmLiqueurAuditAttachRespVo> result = tpmLiqueurAuditAttachService.findAccountList(tpmLiqueurAuditAttachReqVo);
        return Result.ok(result);
    }

    /**
     * @return com.biz.crm.util.Result<java.util.List < com.biz.crm.common.DictItemVo>>
     * @Description 费用上账根据细类编码集合或者上账单号集合查询上账科目集合
     * @Date 2020/10/30
     * @Param [tpmCostTypeFineReqVo]
     **/
    @ApiOperation(value = "费用上账根据细类编码集合或者上账单号集合查询上账科目集合")
    @PostMapping("/financeSubjectsErpCodeByFindCode")
    @CrmLog
    public Result<List<TpmCostTypeFineRespVo>> financeSubjectsErpCodeByFindCode(@RequestBody TpmAccountInvoiceReqVo reqVo) {
        return Result.ok(tpmCostTypeFineService.financeSubjectsErpCodeByFindCode(reqVo));
    }
}
