package com.biz.crm.account.controller;

import com.biz.crm.account.service.ITpmAccountInvoiceService;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.tpm.account.req.TpmAccountInvoiceReqVo;
import com.biz.crm.nebular.tpm.account.resp.TpmAccountInvoiceRespVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

/**
 * 费用上账发票关联表;
 *
 * @author zeyi
 * @date 2020-10-12 17:26:54
 */
@Slf4j
@RestController
@RequestMapping("/tpmAccountInvoiceController")
@Api(tags = "费用上账发票关联表;")
public class TpmAccountInvoiceController {

    @Resource
    private ITpmAccountInvoiceService iTpmAccountInvoiceService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<TpmAccountInvoiceRespVo>> list(@RequestBody TpmAccountInvoiceReqVo tpmAccountInvoiceReqVo) {
        PageResult<TpmAccountInvoiceRespVo> result = iTpmAccountInvoiceService.findList(tpmAccountInvoiceReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @GetMapping("/query")
    @CrmLog
    public Result<TpmAccountInvoiceRespVo> query(@RequestParam(value = "id", required = false) String id) {
        TpmAccountInvoiceRespVo respVo = iTpmAccountInvoiceService.query(id);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody TpmAccountInvoiceReqVo tpmAccountInvoiceReqVo) {
        iTpmAccountInvoiceService.save(tpmAccountInvoiceReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody TpmAccountInvoiceReqVo tpmAccountInvoiceReqVo) {
        iTpmAccountInvoiceService.update(tpmAccountInvoiceReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        iTpmAccountInvoiceService.deleteBatch(ids);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody List<String> ids) {
        iTpmAccountInvoiceService.enableBatch(ids);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {
        iTpmAccountInvoiceService.disableBatch(ids);
        return Result.ok("禁用成功");
    }
}
