package com.biz.crm.account.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.account.model.TpmAccountDetailEntity;
import com.biz.crm.interceptor.SqlPrivilege;
import com.biz.crm.nebular.tpm.account.req.TpmAccountDetailReqVo;
import com.biz.crm.nebular.tpm.account.resp.TpmAccountDetailRespVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 费用上账表;
 *
 * @author zeyi
 * @date 2020-10-12 17:26:54
 */
public interface TpmAccountDetailMapper extends BaseMapper<TpmAccountDetailEntity> {
    /**
     * 列表
     *
     * @param page
     * @param tpmAccountDetailReqVo
     * @return
     */
    @SqlPrivilege(posCode = "create_pos_code",orgCode = "create_org_code")
    List<TpmAccountDetailRespVo> findList(Page<TpmAccountDetailRespVo> page, @Param("vo") TpmAccountDetailReqVo tpmAccountDetailReqVo);

    /**
     * 根据ids进行批量删除，同时删除产品和发票数据
     * @param ids
     */
    void deleteBatchByIds(@Param("ids") List<String> ids);

}
